# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .health_service_status import HealthServiceStatus


class HealthService(UniversalBaseModel):
    last_update: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="lastUpdate")] = pydantic.Field()
    """
    The data time when the service status was last updated, in RFC3339 format
    """

    service: str = pydantic.Field()
    """
    The name of the service
    """

    status: HealthServiceStatus = pydantic.Field()
    """
    The health status of the service
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
