# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.bucket_list_response import BucketListResponse
from ..types.bucket_response import BucketResponse
from ..types.bucket_update_response import BucketUpdateResponse
from ..types.message_response import MessageResponse
from .raw_client import AsyncRawBucketsClient, RawBucketsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BucketsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBucketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBucketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBucketsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        n: typing.Optional[int] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BucketListResponse:
        """
        List all buckets within your GroundX account

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned buckets. Accepts 1-100 with a default of 20.

        next_token : typing.Optional[str]
            A token for pagination. If the number of buckets for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n buckets.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BucketListResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.buckets.list(
            n=1,
            next_token="nextToken",
        )
        """
        _response = self._raw_client.list(n=n, next_token=next_token, request_options=request_options)
        return _response.data

    def create(self, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> BucketResponse:
        """
        Create a new bucket.

        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BucketResponse
            Bucket successfully created

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.buckets.create(
            name="your_bucket_name",
        )
        """
        _response = self._raw_client.create(name=name, request_options=request_options)
        return _response.data

    def get(self, bucket_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> BucketResponse:
        """
        Look up a specific bucket by its bucketId.

        Parameters
        ----------
        bucket_id : int
            The bucketId of the bucket to look up.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BucketResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.buckets.get(
            bucket_id=1,
        )
        """
        _response = self._raw_client.get(bucket_id, request_options=request_options)
        return _response.data

    def update(
        self, bucket_id: int, *, new_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> BucketUpdateResponse:
        """
        Rename a bucket.

        Parameters
        ----------
        bucket_id : int
            The bucketId of the bucket being updated.

        new_name : str
            The new name of the bucket being renamed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BucketUpdateResponse
            Bucket successfully updated

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.buckets.update(
            bucket_id=1,
            new_name="your_bucket_name",
        )
        """
        _response = self._raw_client.update(bucket_id, new_name=new_name, request_options=request_options)
        return _response.data

    def delete(self, bucket_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> MessageResponse:
        """
        Delete a bucket.

        Parameters
        ----------
        bucket_id : int
            The bucketId of the bucket being deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Bucket successfully deleted

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.buckets.delete(
            bucket_id=1,
        )
        """
        _response = self._raw_client.delete(bucket_id, request_options=request_options)
        return _response.data


class AsyncBucketsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBucketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBucketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBucketsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        n: typing.Optional[int] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BucketListResponse:
        """
        List all buckets within your GroundX account

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned buckets. Accepts 1-100 with a default of 20.

        next_token : typing.Optional[str]
            A token for pagination. If the number of buckets for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n buckets.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BucketListResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.buckets.list(
                n=1,
                next_token="nextToken",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(n=n, next_token=next_token, request_options=request_options)
        return _response.data

    async def create(self, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> BucketResponse:
        """
        Create a new bucket.

        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BucketResponse
            Bucket successfully created

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.buckets.create(
                name="your_bucket_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, request_options=request_options)
        return _response.data

    async def get(self, bucket_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> BucketResponse:
        """
        Look up a specific bucket by its bucketId.

        Parameters
        ----------
        bucket_id : int
            The bucketId of the bucket to look up.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BucketResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.buckets.get(
                bucket_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(bucket_id, request_options=request_options)
        return _response.data

    async def update(
        self, bucket_id: int, *, new_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> BucketUpdateResponse:
        """
        Rename a bucket.

        Parameters
        ----------
        bucket_id : int
            The bucketId of the bucket being updated.

        new_name : str
            The new name of the bucket being renamed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BucketUpdateResponse
            Bucket successfully updated

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.buckets.update(
                bucket_id=1,
                new_name="your_bucket_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(bucket_id, new_name=new_name, request_options=request_options)
        return _response.data

    async def delete(
        self, bucket_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Delete a bucket.

        Parameters
        ----------
        bucket_id : int
            The bucketId of the bucket being deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Bucket successfully deleted

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.buckets.delete(
                bucket_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(bucket_id, request_options=request_options)
        return _response.data
