MATERIAALDATA = [
    {   'broader': [],
        'id': 1,
        'labels': [   {   'label': 'aardewerk',
                           'language': 'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': 'ceramiek',
                           'language': 'nl-BE',
                           'type': 'altLabel'},
                       {   'label': 'keramiek',
                           'language': 'nl-BE',
                           'type': 'altLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [2, 5, 6],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Aardewerk of keramiek is gebakken klei. Aardewerk wordt gebruikt voor het vervaardigen van vaatwerk, bouwmaterialen, beeldjes, enz\u2026',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/1'},
    {   'broader': [8],
        'id': 48,
        'labels': [   {   'label': 'aluminium',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Aluminium is een metaal uit de derde groep van het periodiek systeem (chemisch element Al). Het is dof zilverachtig van kleur en zeer licht.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Van Dale groot woordenboek van de Nederlandse taal. 14de editie, Utrecht/Antwerpen, 2005',
                            'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/48'},
    {   'broader': [32],
        'id': 33,
        'labels': [   {   'label': 'amber',
                           'language': 'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': 'barnsteen',
                           'language': 'nl-BE',
                           'type': 'altLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Amber is een fossiele hars afkomstig uit naaldbomen en wordt gebruikt voor het maken van kralen, hangers, knopen en dergelijke meer.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [{   'citation': 'VIOE', 'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/33'},
    {   'broader': [],
        'id': 38,
        'labels': [   {   'label': 'beton',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [39],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Beton is een kunstmatig materiaal dat lijkt op steen en als bouwmateriaal gebruikt wordt. Het bestaat uit cement of kalk waaraan zand, grind of steenslag wordt toegevoegd.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [{   'citation': 'VIOE', 'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/38'},
    {   'broader': [9],
        'id': 10,
        'labels': [   {   'label': 'bladgoud',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Bladgoud is een term die verwijst naar platen goud die tot een zeer geringe dikte (meestal circa 0,1 micrometer) zijn gehamerd of gewalst.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/10'},
    {   'broader': [21],
        'id': 23,
        'labels': [   {   'label': 'bont',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Bont is een gelooide dierlijke huid, dicht bezet met haren. Het wordt voornamelijk gebruikt voor het maken van kleding.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/23'},
    {   'broader': [21],
        'id': 24,
        'labels': [   {   'label': 'botmateriaal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [25, 26],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Botmateriaal of been is een combinatie van organisch en anorganisch materiaal die hoofdzakelijk bestaat uit collageen en calciumfosfaat.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/24'},
    {   'broader': [13],
        'id': 14,
        'labels': [   {   'label': 'brons',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Brons is een legering van koper en tin.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/14'},
    {   'broader': [],
        'id': 49,
        'labels': [   {   'label': 'cement',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Cement is de benaming voor verschillende stoffen die een snel verhardend bindmiddel voor bouwwerken (mortel) opleveren.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Van Dale groot woordenboek van de Nederlandse taal. 14de editie, Utrecht/Antwerpen, 2005',
                            'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/49'},
    {   'broader': [24],
        'id': 25,
        'labels': [   {   'label': 'dierlijk botmateriaal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Botmateriaal of been is een combinatie van organisch en anorganisch materiaal die hoofdzakelijk bestaat uit collageen en calciumfosfaat; het vormt het geraamte van de meeste gewervelde dieren.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/25'},
    {   'broader': [38],
        'id': 39,
        'labels': [   {   'label': 'gewapend beton',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Gewapend beton is een combinatie van beton en staal.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/39'},
    {   'broader': [21],
        'id': 27,
        'labels': [   {   'label': 'gewei',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Gewei wordt gevormd door enkele uitstulpingen van been op de voorhoofdsbeenderen van gehoefde dieren die behoren tot de hertenfamilie. Het wordt jaarlijks afgeworpen. Gewei wordt door de mens gebruikt als grondstof voor het maken van artefacten.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/27'},
    {   'broader': [],
        'id': 7,
        'labels': [   {   'label': 'glas',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Glas is een amorfe, anorganische substantie die wordt gemaakt door silica (siliciumdioxide) te fuseren met een basisoxide, meestal transparant maar vaak ook doorzichtig of ondoorschijnend.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/7'},
    {   'broader': [8],
        'id': 9,
        'labels': [   {   'label': 'goud',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [10],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Te gebruiken voor het zuivere metaalelement met het symbool Au. Het is een zacht, zwaar, chemisch inactief en geel metaal en wordt al sinds de oudheid als edel beschouwd. Het dient in vele culturen als de basis voor materi\xeble handelswaarden. Ook te gebruiken voor het metaal wanneer het wordt bewerkt en vervormd om, meestal in combinatie met andere stoffen, verschillende voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/9'},
    {   'broader': [21],
        'id': 28,
        'labels': [   {   'label': 'hoorn',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Hoorn is een uitgroei van aangepaste huid of zeer compact haar, vaak in paren die uitsteken vanaf de voorhoofdsbotten aan beide zijden van de schedel en bestaat uit een permanente opperhuid van keratine. De benen kern van een hoorn wordt hoornpit genoemd.',
                          'type': 'scopeNote'},
                      {   'language': 'nl-BE',
                          'markup': None,
                          'note': "Te onderscheiden van 'gewei', dat bestaat uit aangepast been.",
                          'type': 'note'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/28'},
    {   'broader': [32],
        'id': 35,
        'labels': [   {   'label': 'hout',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Hout is het voornaamste bestanddeel van bomen en struiken. Hout is een belangrijke grondstof en wordt voor allerlei toepassingen gebruikt, zoals voor bouwconstructies, als brandstof, voor het maken van papier, enz\u2026',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/35'},
    {   'broader': [32],
        'id': 36,
        'labels': [   {   'label': 'houtskool',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Houtskool is een onzuivere vorm van grafietkoolstof die ontstaat als reststof bij de gedeeltelijke verbranding van koolstofhoudend materiaal, of bij verhitting van dit materiaal waarbij zuurstof in beperkte hoeveelheid aanwezig is.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/36'},
    {   'broader': [21],
        'id': 29,
        'labels': [   {   'label': 'huid',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [30],
        'notes': [],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/29'},
    {   'broader': [8],
        'id': 11,
        'labels': [   {   'label': 'ijzer',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Te gebruiken voor het zuivere metaalelement met het symbool Fe. Het is een glimmend, zilverachtig zacht metaal dat roest wanneer het aan vochtige lucht wordt blootgesteld. Gebruik ook voor dit metaal als het wordt verwerkt en gevormd, meestal in combinatie met andere stoffen, om diverse objecten en materialen te maken.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/11'},
    {   'broader': [8],
        'id': 12,
        'labels': [   {   'label': 'koper',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [13],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Te gebruiken voor het zuivere metaalelement met het symbool Cu. Het is roodachtig van kleur en is zeer smeedbaar en kneedbaar. Ook te gebruiken voor het metaal wanneer het wordt bewerkt en gevormd om, meestal in combinatie met andere stoffen, verschillende voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/12'},
    {   'broader': [12],
        'id': 13,
        'labels': [   {   'label': 'koperlegeringen',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [14, 15],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Een koperlegering is een vast mengsel van koper met andere metalen.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [{   'citation': 'VIOE', 'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/13'},
    {   'broader': [],
        'id': 20,
        'labels': [   {   'label': 'kunststof',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Een kunststof is een langs chemische weg gemaakte stof die gebruikt wordt voor de vervaardiging van de meest verschillende zaken. In de scheepsbouw gaat het om een composiet van glasvezel (of andere meer moderne vezels) met polyester of epoxy, al dan niet in combinatie met een core-materiaal.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': '1) Van Dale groot woordenboek van de Nederlandse taal. 14de editie, Utrecht/Antwerpen, 2005\n2) Onroerend Erfgoed',
                            'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/20'},
    {   'broader': [43],
        'id': 44,
        'labels': [   {   'label': 'kwartsiet van Tienen',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Het kwartsiet van Tienen is een metamorf gesteente waarbij de oorspronkelijke sedimentaire kwartskorrels door secundaire aangroei met elkaar zijn vergroeid. Dit verklaart de geringe porositeit en sterke cohesie van dit gesteente.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Gullentops F. &amp; Wouters L., Delfstoffen in Vlaanderen, Ministerie van de Vlaamse gemeenschap, Departement EWBL.',
                            'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/44'},
    {   'broader': [42],
        'id': 43,
        'labels': [   {   'label': 'kwartsitisch lithisch materiaal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [44, 45],
        'notes': [],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/43'},
    {   'broader': [29],
        'id': 30,
        'labels': [   {   'label': 'leer',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Leer is de huid of het vel van een dier, die is gelooid om tegen bederf te beschermen en in droge toestand relatief zacht en soepel te maken.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/30'},
    {   'broader': [40],
        'id': 42,
        'labels': [   {   'label': 'lithisch materiaal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [43, 46],
        'notes': [],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/42'},
    {   'broader': [8],
        'id': 16,
        'labels': [   {   'label': 'lood',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Te gebruiken voor het zuivere metaalelement met het symbool Pb. Het metaal is zacht, kneedbaar en vaalgrijs van kleur. Ook te gebruiken voor het metaal wanneer het wordt bewerkt en gevormd om, meestal in combinatie met andere stoffen, verscheidene voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/16'},
    {   'broader': [24],
        'id': 26,
        'labels': [   {   'label': 'menselijk botmateriaal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Botmateriaal of been is een combinatie van organisch en/of anorganisch materiaal die hoofdzakelijk bestaat uit collageen en calciumfosfaat; het vormt het geraamte van de meeste gewervelden, waaronder de mens.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/26'},
    {   'broader': [13],
        'id': 15,
        'labels': [   {   'label': 'messing',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Messing is een legering van koper en zink, meestal met koper als het voornaamste element en met zink als maximaal 40% van het gewicht.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/15'},
    {   'broader': [],
        'id': 8,
        'labels': [   {   'label': 'metaal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [9, 11, 12, 16, 17, 18, 19, 48],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Metaal omvat een grote groep stoffen die meestal een kenmerkende glans vertonen. Het zijn goede geleiders van elektriciteit en warmte, ze zijn ondoorschijnend, kunnen smelten en zijn meestal pletbaar of kneedbaar.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/8'},
    {   'broader': [40],
        'id': 41,
        'labels': [   {   'label': 'natuursteen',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Natuursteen is een term die wordt gebruik voor gesteenten die in de natuur worden aangetroffen en die, na eventuele bewerking, kunnen dienen als bouwmateriaal. Hieronder vallen steensoorten zoals graniet, tefriet, Doornikse kalksteen, zandsteen, Balegemse kalkzandsteen, Gobertangesteen, arduin (blauwe hardsteen), ijzerzandsteen, veldsteen, Ypresiaanse nummilietenkalksteen, Avendersteen, schieffer, enz...',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': '1) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a> 2) VIOE',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/41'},
    {   'broader': [],
        'id': 21,
        'labels': [   {   'label': 'organisch materiaal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [23, 24, 27, 28, 29, 32],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Organisch materiaal is materiaal dat koolstof bevat, inclusief de materialen die afkomstig zijn van levende organismen.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/21'},
    {   'broader': [1],
        'id': 2,
        'labels': [   {   'label': 'pijpaarde',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Pijpaarde is een bepaalde soort fijne, witbakkende klei die gebruikt werd voor het maken van pijpen, beeldjes, fijn aardewerk enz...',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [{   'citation': 'VIOE', 'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/2'},
    {   'broader': [21],
        'id': 32,
        'labels': [   {   'label': 'plantaardig materiaal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [33, 35, 36, 37],
        'notes': [],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/32'},
    {   'broader': [],
        'id': 50,
        'labels': [   {   'label': 'pleister',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': ['http://vocab.getty.edu/aat/300014922'],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Pleister verwijst naar zacht, plastisch materiaal dat kan worden uitgerold of uitgestreken op een muur, plafond of ander oppervlak waarop het vervolgens verhardt. In de context van kunst en architectuur verwijst het meestal specifiek naar een mengsel van water, kalk en zand, vaak in combinatie met andere materialen zoals dierenhaar, waardoor het materiaal meer kracht, textuur en - als het oppervlak daarna wordt geschilderd - poreusheid krijgt.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Art &amp; Architecture Thesaurus',
                            'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/50'},
    {   'broader': [1],
        'id': 5,
        'labels': [   {   'label': 'porselein',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Porselein verwijst naar een bepaald soort hardgebakken aardewerk van vuurbestendige witte klei, kaolien, waaraan veldspaat en kwarts worden toegevoegd.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [{   'citation': 'VIOE', 'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/5'},
    {   'broader': [],
        'id': 31,
        'labels': [   {   'label': 'schelp',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'De het uitwendig skelet van een weekdier samengesteld uit kalk of andere mineralen.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/31'},
    {   'broader': [42],
        'id': 46,
        'labels': [   {   'label': 'silex',
                           'language': 'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': 'vuursteen',
                           'language': 'nl-BE',
                           'type': 'altLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Een fijnkorrelig, compact sedimentair gesteente dat bestaat uit kwartskristallen.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/46'},
    {   'broader': [8],
        'id': 17,
        'labels': [   {   'label': 'staal',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Staal is een legering van ijzer en koolstof.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/17'},
    {   'broader': [],
        'id': 40,
        'labels': [   {   'label': 'steen',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [41, 42],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Steen is een harde stof met een minerale samenstelling.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/40'},
    {   'broader': [1],
        'id': 6,
        'labels': [   {   'label': 'steengoed',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Steengoed is een soort aardewerk dat gemaakt is van klei en smeltbaar gesteente. Het materiaal wordt zolang gebakken tot er gedeeltelijke verglazing optreedt, waardoor het materiaal waterdicht wordt.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/6'},
    {   'broader': [32],
        'id': 37,
        'labels': [   {   'label': 'textiel',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Textiel is een materiaal dat tot stand is gekomen door middel van weven, vervilten, knopen, twijnen of andersoortige bewerking van natuurlijke of synthetische vezels zodanig dat zij bijeenblijven.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/37'},
    {   'broader': [8],
        'id': 18,
        'labels': [   {   'label': 'tin',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Te gebruiken voor het zuivere metaalelement met het symbool Sn. Het zilverachtig witte metaal is zacht en buigzaam. Ook te gebruiken voor dit metaal wanneer het wordt bewerkt en gevormd om, meestal in combinatie met andere stoffen, diverse voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/18'},
    {   'broader': [43],
        'id': 45,
        'labels': [   {   'label': 'wommersomkwartsiet',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Wommersomkwartsiet vertoont een textuur van hoekige kwartskorrels in een fijnkorrelig kwartscement ingebed. Deze gesteentesoort komt schijnbaar alleen voor in Wommersom, nabij Tienen. Het vertoont enige gelijkenis met silex en werd alsdusdanig ook gebruikt om prehistorische werktuigen te maken.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Gullentops F. &amp; Wouters L., Delfstoffen in Vlaanderen, Ministerie van de Vlaamse gemeenschap, Departement EWBL.',
                            'markup': None}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/45'},
    {   'broader': [8],
        'id': 19,
        'labels': [   {   'label': 'zilver',
                           'language': 'nl-BE',
                           'type': 'prefLabel'}],
        'matches': {   'broad': [],
                        'close': [],
                        'exact': [],
                        'narrow': [],
                        'related': []},
        'member_of': [],
        'narrower': [],
        'notes': [   {   'language': 'nl-BE',
                          'markup': None,
                          'note': 'Te gebruiken voor het zuivere metaalelement met het symbool Ag. Het metaal is smeedbaar, vervormbaar en wit van kleur met een kenmerkende glans en wordt als edel beschouwd. Ook te gebruiken voor dit metaal wanneer het wordt bewerkt en gevormd om, meestal in combinatie met andere stoffen, diverse voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        'related': [],
        'sources': [   {   'citation': 'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        'subordinate_arrays': [],
        'type': 'concept',
        'uri': 'https://id.erfgoed.net/thesauri/materialen/19'}]
