"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Plone = exports.PloneVariant = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-29");
const constructs_1 = require("constructs");
const deployment_1 = require("./deployment");
const k8s_1 = require("./imports/k8s");
const service_1 = require("./service");
var PloneVariant;
(function (PloneVariant) {
    PloneVariant["VOLTO"] = "volto";
    PloneVariant["CLASSICUI"] = "classicui";
})(PloneVariant || (exports.PloneVariant = PloneVariant = {}));
class Plone extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        this.frontendServiceName = undefined;
        this.siteId = options.siteId ?? 'Plone';
        this.variant = options.variant ?? PloneVariant.VOLTO;
        // ------------------------------------------------------------------------
        // Backend
        const backend = options.backend ?? {};
        const backendLabels = {
            'app.kubernetes.io/name': 'plone-backend',
            'app.kubernetes.io/component': 'backend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        const backendPort = 8080;
        // Options
        var backendOptions = {
            labels: backendLabels,
            image: {
                image: backend.image ?? 'plone/plone-backend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: backend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: backend.replicas,
            limitCpu: backend.limitCpu ?? '500m',
            limitMemory: backend.limitMemory ?? '512Mi',
            requestCpu: backend.requestCpu ?? '200m',
            requestMemory: backend.requestMemory ?? '256Mi',
            pdb: {
                maxUnavailable: backend.maxUnavailable ?? undefined,
                minAvailable: backend.minAvailable ?? undefined,
            },
            port: backendPort,
            environment: backend.environment,
        };
        // Probing
        const backendActionHttpGet = {
            path: '/',
            port: k8s_1.IntOrString.fromNumber(backendPort),
        };
        if (backend.livenessEnabled ?? false) {
            backendOptions.livenessProbe = {
                httpGet: backendActionHttpGet,
                initialDelaySeconds: backend.livenessInitialDelaySeconds ?? 30,
                timeoutSeconds: backend.livenessIimeoutSeconds ?? 5,
                periodSeconds: backend.livenessPeriodSeconds ?? 10,
                successThreshold: backend.livenessSuccessThreshold ?? 1,
                failureThreshold: backend.livenessFailureThreshold ?? 3,
            };
        }
        if (backend.readinessEnabled ?? true) {
            backendOptions.readinessProbe = {
                httpGet: backendActionHttpGet,
                initialDelaySeconds: backend.readinessInitialDelaySeconds ?? 10,
                timeoutSeconds: backend.readinessIimeoutSeconds ?? 15,
                periodSeconds: backend.readinessPeriodSeconds ?? 10,
                successThreshold: backend.readinessSuccessThreshold ?? 1,
                failureThreshold: backend.readinessFailureThreshold ?? 3,
            };
        }
        // Deployment
        var backendDeployment = new deployment_1.PloneDeployment(this, 'backend', backendOptions);
        // Service
        const backendService = new service_1.PloneService(backendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-backend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: backendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(backendDeployment) },
        });
        this.backendServiceName = backendService.name;
        // ------------------------------------------------------------------------
        // Frontend
        if (this.variant == PloneVariant.VOLTO) {
            const frontend = options.frontend ?? {};
            const frontendPort = 3000;
            const frontendLabels = {
                'app.kubernetes.io/name': 'plone-frontend',
                'app.kubernetes.io/component': 'frontend',
                'app.kubernetes.io/version': options.version ?? 'undefined',
            };
            // Environment for RAZZLE
            var frontendEnvironment = frontend.environment ?? new kplus.Env([], {});
            if (frontendEnvironment.variables.RAZZLE_INTERNAL_API_PATH === undefined) {
                // connect with backend service
                frontendEnvironment?.addVariable('RAZZLE_INTERNAL_API_PATH', kplus.EnvValue.fromValue(`http://${backendService.name}:${backendPort}/${this.siteId}`));
            }
            // Options
            var frontendOptions = {
                labels: frontendLabels,
                image: {
                    image: frontend.image ?? 'plone/plone-frontend:latest',
                    imagePullSecrets: options.imagePullSecrets ?? [],
                    imagePullPolicy: frontend.imagePullPolicy ?? 'IfNotPresent',
                },
                replicas: frontend.replicas,
                limitCpu: frontend.limitCpu ?? '500m',
                limitMemory: frontend.limitMemory ?? '1Gi',
                requestCpu: frontend.requestCpu ?? '200m',
                requestMemory: frontend.requestMemory ?? '256Mi',
                pdb: {
                    maxUnavailable: frontend.maxUnavailable ?? undefined,
                    minAvailable: frontend.minAvailable ?? undefined,
                },
                port: frontendPort,
                environment: frontendEnvironment,
            };
            // Probing
            const frontendActionHttpGet = {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(frontendPort),
            };
            if (frontend.livenessEnabled ?? false) {
                frontendOptions.livenessProbe = {
                    httpGet: frontendActionHttpGet,
                    initialDelaySeconds: frontend.livenessInitialDelaySeconds ?? 30,
                    timeoutSeconds: frontend.livenessIimeoutSeconds ?? 5,
                    periodSeconds: frontend.livenessPeriodSeconds ?? 10,
                    successThreshold: frontend.livenessSuccessThreshold ?? 1,
                    failureThreshold: frontend.livenessFailureThreshold ?? 3,
                };
            }
            if (frontend.readinessEnabled ?? true) {
                frontendOptions.readinessProbe = {
                    httpGet: frontendActionHttpGet,
                    initialDelaySeconds: frontend.readinessInitialDelaySeconds ?? 10,
                    timeoutSeconds: frontend.readinessIimeoutSeconds ?? 15,
                    periodSeconds: frontend.readinessPeriodSeconds ?? 10,
                    successThreshold: frontend.readinessSuccessThreshold ?? 1,
                    failureThreshold: frontend.readinessFailureThreshold ?? 3,
                };
            }
            // Deployment
            const frontendDeployment = new deployment_1.PloneDeployment(this, 'frontend', frontendOptions);
            // Service
            const frontendService = new service_1.PloneService(frontendDeployment, 'service', {
                labels: {
                    'app.kubernetes.io/name': 'plone-frontend-service',
                    'app.kubernetes.io/component': 'service',
                },
                targetPort: frontendPort,
                selectorLabel: { app: cdk8s_1.Names.toLabelValue(frontendDeployment) },
            });
            this.frontendServiceName = frontendService.name;
        }
    }
}
exports.Plone = Plone;
_a = JSII_RTTI_SYMBOL_1;
Plone[_a] = { fqn: "@bluedynamics/cdk8s-plone.Plone", version: "0.0.39" };
//# sourceMappingURL=data:application/json;base64,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