import { Construct } from 'constructs';
import { Plone } from './plone';
export interface PloneHttpcacheOptions {
    /**
     * plone chart
     * @default - none
     */
    readonly plone: Plone;
    /** varnishVcl
     * @default - file in config folder
     */
    readonly varnishVcl?: string;
    /** varnishVclFile
     * @default - undefined
     */
    readonly varnishVclFile?: string | undefined;
    /** existingSecret - Read admin credentials from user provided secret
     * @default - undefined
    */
    readonly existingSecret?: string;
    readonly limitCpu?: string;
    readonly limitMemory?: string;
    readonly requestCpu?: string;
    readonly requestMemory?: string;
}
export declare class PloneHttpcache extends Construct {
    readonly httpcacheServiceName: string;
    constructor(scope: Construct, id: string, options: PloneHttpcacheOptions);
}
