/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.modularity;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.modularity.OntologySegmenter;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class SyntacticLocalityModuleExtractor
implements OntologySegmenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyntacticLocalityModuleExtractor.class);
    private final OntologyAxiomSet ontologyAxiomSet;
    private final OWLOntology ontology;
    private final OWLOntologyManager manager;
    private ModuleType moduleType;

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, Stream<OWLAxiom> axs, ModuleType moduleType) {
        this(man, axs, moduleType, false);
    }

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, Stream<OWLAxiom> axs, ModuleType moduleType, boolean excludeAssertions) {
        this.moduleType = OWLAPIPreconditions.checkNotNull(moduleType, "moduleType cannot be null");
        this.manager = OWLAPIPreconditions.checkNotNull(man, "man cannot be null");
        Predicate<OWLAxiom> filter = ax -> excludeAssertions ? !AxiomType.ABoxAxiomTypes.contains(ax.getAxiomType()) : true;
        List<OWLAxiom> collect = OWLAPIStreamUtils.asList(axs.filter(filter));
        this.ontologyAxiomSet = new OntologyAxiomSet(collect);
        try {
            this.ontology = OWLAPIPreconditions.checkNotNull(man.createOntology(collect));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, OWLOntology ont, ModuleType moduleType) {
        this(man, SyntacticLocalityModuleExtractor.asAxiomSet(ont), moduleType);
    }

    private static Stream<OWLAxiom> asAxiomSet(OWLOntology ont) {
        return ont.axioms(Imports.INCLUDED);
    }

    static Set<OWLClass> superOrSubClasses(int superOrSubClassLevel, boolean superVsSub, @Nullable OWLReasoner reasoner, Set<OWLClass> classesInSig) {
        OWLAPIPreconditions.checkNotNull(reasoner);
        assert (reasoner != null);
        HashSet<OWLClass> superOrSubClasses = new HashSet<OWLClass>();
        if (superOrSubClassLevel < 0) {
            SyntacticLocalityModuleExtractor.negativeLevel(superVsSub, reasoner, classesInSig, superOrSubClasses);
        } else if (superOrSubClassLevel > 0) {
            SyntacticLocalityModuleExtractor.positiveLevel(superOrSubClassLevel, superVsSub, reasoner, classesInSig, superOrSubClasses);
        }
        return superOrSubClasses;
    }

    protected static void positiveLevel(int superOrSubClassLevel, boolean superVsSub, OWLReasoner reasoner, Set<OWLClass> classesInSig, Set<OWLClass> superOrSubClasses) {
        LinkedList<OWLClass> toBeSuClassedNext = new LinkedList<OWLClass>(classesInSig);
        LinkedList<OWLClass> suClassesToBeAdded = new LinkedList<OWLClass>();
        for (int i = 0; i < superOrSubClassLevel; ++i) {
            LinkedList<OWLClass> toBeSuClassedNow = toBeSuClassedNext;
            toBeSuClassedNext = new LinkedList();
            SyntacticLocalityModuleExtractor.processLayer(superVsSub, reasoner, classesInSig, toBeSuClassedNow, toBeSuClassedNext, suClassesToBeAdded);
        }
        superOrSubClasses.addAll(suClassesToBeAdded);
    }

    protected static void processLayer(boolean superVsSub, OWLReasoner reasoner, Set<OWLClass> classesInSig, Queue<OWLClass> toBeSuClassedNow, Queue<OWLClass> toBeSuClassedNext, Queue<OWLClass> suClassesToBeAdded) {
        for (OWLClassExpression oWLClassExpression : toBeSuClassedNow) {
            Stream<OWLClass> suClasses = superVsSub ? reasoner.getSuperClasses(oWLClassExpression, true).entities() : reasoner.getSubClasses(oWLClassExpression, true).entities();
            suClasses.filter(c -> !classesInSig.contains(c) && suClassesToBeAdded.add((OWLClass)c)).forEach(toBeSuClassedNext::add);
        }
    }

    protected static void negativeLevel(boolean superVsSub, OWLReasoner reasoner, Set<OWLClass> classesInSig, Set<OWLClass> superOrSubClasses) {
        for (OWLClassExpression oWLClassExpression : classesInSig) {
            NodeSet<OWLClass> nodes = superVsSub ? reasoner.getSuperClasses(oWLClassExpression, false) : reasoner.getSubClasses(oWLClassExpression, false);
            OWLAPIStreamUtils.add(superOrSubClasses, nodes.entities());
        }
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = OWLAPIPreconditions.checkNotNull(moduleType, "moduleType cannot be null");
    }

    boolean[] extractLogicalAxioms(boolean[] subOnt, Set<OWLEntity> signature, LocalityClass localityClass) {
        boolean[] mod = this.ontologyAxiomSet.getSubset(false);
        boolean[] q2 = this.ontologyAxiomSet.cloneSubset(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        int loopNumber = 0;
        while (change) {
            change = false;
            LOGGER.info("  Loop {}", (Object)(++loopNumber));
            for (int i = 0; i < q2.length; ++i) {
                OWLAxiom axiom = this.ontologyAxiomSet.getAxiom(i);
                if (!q2[i]) continue;
                if (!sle.isLocal(axiom, signature)) {
                    LOGGER.info("      Non-local axiom:   {}", (Object)axiom);
                    mod[i] = true;
                    q2[i] = false;
                    int oldSize = signature.size();
                    OWLAPIStreamUtils.add(signature, axiom.signature());
                    if (signature.size() <= oldSize) continue;
                    change = true;
                    LOGGER.info("    New signature:   {}", signature);
                    continue;
                }
                LOGGER.info("      Local axiom:       {}", (Object)axiom);
            }
        }
        return mod;
    }

    Set<OWLAxiom> extract(Set<OWLAxiom> subOnt, Set<OWLEntity> signature, LocalityClass localityClass) {
        HashSet<OWLAxiom> mod = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> q2 = new HashSet<OWLAxiom>(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        int loopNumber = 0;
        while (change) {
            change = false;
            LOGGER.info("  Loop {}", (Object)(++loopNumber));
            HashSet<OWLAxiom> q2remove = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : q2) {
                if (!sle.isLocal(ax, signature)) {
                    LOGGER.info("      Non-local axiom:   {}", (Object)ax);
                    mod.add(ax);
                    q2remove.add(ax);
                    int oldSize = signature.size();
                    OWLAPIStreamUtils.add(signature, ax.signature());
                    if (signature.size() <= oldSize) continue;
                    change = true;
                    LOGGER.info("    New signature:   {}", signature);
                    continue;
                }
                LOGGER.info("      Local axiom:       {}", (Object)ax);
            }
            q2.removeAll(q2remove);
        }
        return mod;
    }

    Set<OWLAxiom> enrich(Set<OWLAxiom> module, Set<OWLEntity> sig) {
        HashSet<OWLAxiom> enrichedModule = new HashSet<OWLAxiom>(module);
        LOGGER.info("\nEnriching with declaration axioms, annotation axioms, same/different individual axioms ...");
        for (OWLEntity entity : sig) {
            List<OWLDeclarationAxiom> declarationAxioms = OWLAPIStreamUtils.asList(this.ontology.declarationAxioms(entity));
            enrichedModule.addAll(declarationAxioms);
            if (!LOGGER.isInfoEnabled()) continue;
            declarationAxioms.forEach(a -> LOGGER.info("  Added entity declaration axiom:   {}", a));
        }
        HashSet<IRI> iris = new HashSet<IRI>(sig.size());
        for (OWLEntity i2 : sig) {
            iris.add(i2.getIRI());
        }
        this.ontology.axioms(AxiomType.ANNOTATION_ASSERTION).forEach(annotation -> {
            if (iris.contains(annotation.getSubject())) {
                enrichedModule.add((OWLAxiom)annotation);
                LOGGER.info("  Added entity annotation axiom:   {}", annotation);
            }
        });
        for (OWLEntity entity : sig) {
            if (!entity.isOWLNamedIndividual()) continue;
            List<OWLSameIndividualAxiom> sameIndividualAxioms = OWLAPIStreamUtils.asList(this.ontology.sameIndividualAxioms(entity.asOWLNamedIndividual()));
            enrichedModule.addAll(sameIndividualAxioms);
            if (LOGGER.isInfoEnabled()) {
                sameIndividualAxioms.forEach(i -> LOGGER.info("  Added same individual axiom:   {}", i));
            }
            List<OWLDifferentIndividualsAxiom> differentIndividualAxioms = OWLAPIStreamUtils.asList(this.ontology.differentIndividualAxioms(entity.asOWLNamedIndividual()));
            enrichedModule.addAll(differentIndividualAxioms);
            if (!LOGGER.isInfoEnabled()) continue;
            differentIndividualAxioms.forEach(a -> LOGGER.info("  Added different individual axiom:   {}", a));
        }
        return enrichedModule;
    }

    void outputSignature(String preamble, Set<OWLEntity> sig) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(preamble);
            sig.forEach(e -> LOGGER.info("  {}", e));
        }
    }

    Set<OWLAxiom> extractUnnestedModule(Set<OWLEntity> sig, LocalityClass cls) {
        this.outputSignature("\nExtracting " + (Object)((Object)cls) + " module for the following seed signature ... ", sig);
        boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>(sig);
        boolean[] module = this.extractLogicalAxioms(subOnt, signature, cls);
        Set<OWLAxiom> moduleAsSet = this.ontologyAxiomSet.toSet(module);
        return this.enrich(moduleAsSet, signature);
    }

    Set<OWLEntity> enrichSignature(Set<OWLEntity> sig, int superClassLevel, int subClassLevel, @Nullable OWLReasoner reasoner) {
        HashSet<OWLEntity> enrichedSig = new HashSet<OWLEntity>(sig);
        HashSet<OWLClass> classesInSig = new HashSet<OWLClass>();
        for (OWLEntity ent : sig) {
            if (!ent.isOWLClass()) continue;
            classesInSig.add(ent.asOWLClass());
        }
        if (superClassLevel != 0) {
            enrichedSig.addAll(SyntacticLocalityModuleExtractor.superOrSubClasses(superClassLevel, true, reasoner, classesInSig));
        }
        if (subClassLevel != 0) {
            enrichedSig.addAll(SyntacticLocalityModuleExtractor.superOrSubClasses(subClassLevel, false, reasoner, classesInSig));
        }
        return enrichedSig;
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> signature) {
        return this.extract(signature, 0, 0, null);
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> sig, int superClassLevel, int subClassLevel, @Nullable OWLReasoner reasoner) {
        Set<OWLEntity> enrichedSig = this.enrichSignature(sig, superClassLevel, subClassLevel, reasoner);
        switch (this.moduleType) {
            case TOP: {
                return this.extractUnnestedModule(enrichedSig, LocalityClass.TOP_TOP);
            }
            case BOT: {
                return this.extractUnnestedModule(enrichedSig, LocalityClass.BOTTOM_BOTTOM);
            }
            case STAR: {
                return this.extractStar(enrichedSig);
            }
        }
        throw new OWLRuntimeException("Unsupported module type: " + (Object)((Object)this.moduleType));
    }

    protected Set<OWLAxiom> extractStar(Set<OWLEntity> enrichedSig) {
        boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
        boolean nextStepNecessary = true;
        boolean inFirstStep = true;
        LocalityClass localityClass = LocalityClass.BOTTOM_BOTTOM;
        HashSet<OWLEntity> seedSig = new HashSet<OWLEntity>(enrichedSig);
        while (nextStepNecessary) {
            this.outputSignature("\nExtracting " + (Object)((Object)localityClass) + " module for the following seed signature: ", enrichedSig);
            int previousModuleSize = this.ontologyAxiomSet.subsetCardinality(subOnt);
            seedSig = new HashSet<OWLEntity>(enrichedSig);
            subOnt = this.extractLogicalAxioms(subOnt, seedSig, localityClass);
            if (this.ontologyAxiomSet.subsetCardinality(subOnt) == previousModuleSize && !inFirstStep) {
                nextStepNecessary = false;
            }
            inFirstStep = false;
            if (localityClass == LocalityClass.BOTTOM_BOTTOM) {
                localityClass = LocalityClass.TOP_TOP;
                continue;
            }
            localityClass = LocalityClass.BOTTOM_BOTTOM;
        }
        Set<OWLAxiom> moduleAsSet = this.ontologyAxiomSet.toSet(subOnt);
        return this.enrich(moduleAsSet, seedSig);
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri) throws OWLOntologyCreationException {
        return this.extractAsOntology(signature, iri, 0, 0, null);
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri, int superClassLevel, int subClassLevel, @Nullable OWLReasoner reasoner) throws OWLOntologyCreationException {
        return this.manager.createOntology(this.extract(signature, superClassLevel, subClassLevel, reasoner), iri);
    }

    static class OntologyAxiomSet {
        final OWLAxiom[] ax;

        OntologyAxiomSet(List<OWLAxiom> axs) {
            this.ax = axs.toArray(new OWLAxiom[axs.size()]);
        }

        public int size() {
            return this.ax.length;
        }

        public OWLAxiom getAxiom(int i) {
            return this.ax[i];
        }

        public boolean[] getSubset(boolean init) {
            boolean[] subset = new boolean[this.ax.length];
            Arrays.fill(subset, init);
            return subset;
        }

        public boolean[] cloneSubset(boolean[] oldSubset) {
            boolean[] newSubset = new boolean[this.ax.length];
            System.arraycopy(oldSubset, 0, newSubset, 0, this.ax.length);
            return newSubset;
        }

        public int subsetCardinality(boolean[] subset) {
            int card = 0;
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                ++card;
            }
            return card;
        }

        public Set<OWLAxiom> toSet(boolean[] subset) {
            HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>();
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                axs.add(this.ax[i]);
            }
            return axs;
        }
    }
}

