/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public abstract class DefaultNodeSet<E extends OWLObject>
implements NodeSet<E> {
    private final Set<Node<E>> nodes = new LinkedHashSet<Node<E>>();

    public DefaultNodeSet() {
    }

    public DefaultNodeSet(E entity) {
        this.addNode(this.getNode((OWLObject)OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null")));
    }

    public DefaultNodeSet(Node<E> node) {
        this.addNode(OWLAPIPreconditions.checkNotNull(node, "node cannot be null"));
    }

    public DefaultNodeSet(Set<Node<E>> nodes) {
        this.addAllNodes((Collection)OWLAPIPreconditions.checkNotNull(nodes, "nodes cannot be null"));
    }

    public DefaultNodeSet(Stream<Node<E>> nodes) {
        this.addAllNodes(OWLAPIPreconditions.checkNotNull(nodes, "nodes cannot be null"));
    }

    @Override
    public Stream<Node<E>> nodes() {
        return this.nodes.stream();
    }

    public void addEntity(E entity) {
        this.addNode(this.getNode((OWLObject)OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null")));
    }

    public void addNode(Node<E> node) {
        this.nodes.add(OWLAPIPreconditions.checkNotNull(node, "Cannot add null to a NodeSet"));
    }

    public void addAllNodes(Collection<Node<E>> nodeset) {
        nodeset.forEach(this::addNode);
    }

    public void addAllNodes(Stream<Node<E>> nodeset) {
        nodeset.forEach(this::addNode);
    }

    public void addSameEntities(Set<E> entities) {
        this.nodes.add(this.getNode(entities));
    }

    public void addDifferentEntities(Set<E> entities) {
        entities.forEach(e -> this.addNode(this.getNode(e)));
    }

    protected abstract DefaultNode<E> getNode(E var1);

    protected abstract DefaultNode<E> getNode(Set<E> var1);

    @Override
    public Stream<E> entities() {
        return this.nodes().flatMap(Node::entities);
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean containsEntity(E e) {
        for (Node<E> node : this.nodes) {
            if (!node.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSingleton() {
        return this.nodes.size() == 1;
    }

    @Override
    public boolean isTopSingleton() {
        return this.isSingleton() && this.nodes.iterator().next().isTopNode();
    }

    @Override
    public boolean isBottomSingleton() {
        return this.isSingleton() && this.nodes.iterator().next().isBottomNode();
    }

    @Override
    public Iterator<Node<E>> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        return "Nodeset" + this.nodes;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeSet)) {
            return false;
        }
        NodeSet other = (NodeSet)obj;
        return this.nodes.equals(OWLAPIStreamUtils.asUnorderedSet(other.nodes()));
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }
}

