/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail.helpers;

import java.util.Set;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UpdateContext;

class RDFSailRemover
extends RDFHandlerBase {
    private final SailConnection con;
    private final ValueFactory vf;
    private final UpdateContext uc;
    private Resource[] contexts = new Resource[0];

    public RDFSailRemover(SailConnection con, ValueFactory vf, UpdateContext uc) {
        this.con = con;
        this.vf = vf;
        this.uc = uc;
    }

    public void enforceContext(Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.contexts = contexts;
    }

    public boolean enforcesContext() {
        return this.contexts.length != 0;
    }

    public Resource[] getContexts() {
        return this.contexts;
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subj = st.getSubject();
        URI pred = st.getPredicate();
        Value obj = st.getObject();
        Resource ctxt = st.getContext();
        try {
            if (this.enforcesContext()) {
                this.con.removeStatement(this.uc, subj, pred, obj, this.contexts);
            } else if (ctxt == null) {
                Set removeGraphs = this.uc.getDataset().getDefaultRemoveGraphs();
                if (!removeGraphs.isEmpty()) {
                    this.con.removeStatement(this.uc, subj, pred, obj, (Resource[])new URI[removeGraphs.size()]);
                } else {
                    this.con.removeStatement(this.uc, subj, pred, obj, new Resource[0]);
                }
            } else {
                this.con.removeStatement(this.uc, subj, pred, obj, new Resource[]{ctxt});
            }
        }
        catch (SailException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }
}

