/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;
import org.openrdf.repository.sail.config.SailRepositorySchema;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailConfigSchema;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.config.SailRegistry;

public class SailRepositoryConfig
extends RepositoryImplConfigBase {
    private SailImplConfig sailImplConfig;

    public SailRepositoryConfig() {
        super("openrdf:SailRepository");
    }

    public SailRepositoryConfig(SailImplConfig sailImplConfig) {
        this();
        this.setSailImplConfig(sailImplConfig);
    }

    public SailImplConfig getSailImplConfig() {
        return this.sailImplConfig;
    }

    public void setSailImplConfig(SailImplConfig sailImplConfig) {
        this.sailImplConfig = sailImplConfig;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.sailImplConfig == null) {
            throw new RepositoryConfigException("No Sail implementation specified for Sail repository");
        }
        try {
            this.sailImplConfig.validate();
        }
        catch (SailConfigException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public Resource export(Graph graph) {
        Resource repImplNode = super.export(graph);
        if (this.sailImplConfig != null) {
            Resource sailImplNode = this.sailImplConfig.export(graph);
            graph.add(repImplNode, SailRepositorySchema.SAILIMPL, (Value)sailImplNode, new Resource[0]);
        }
        return repImplNode;
    }

    public void parse(Graph graph, Resource repImplNode) throws RepositoryConfigException {
        try {
            Literal typeLit;
            Resource sailImplNode = GraphUtil.getOptionalObjectResource((Graph)graph, (Resource)repImplNode, (URI)SailRepositorySchema.SAILIMPL);
            if (sailImplNode != null && (typeLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)sailImplNode, (URI)SailConfigSchema.SAILTYPE)) != null) {
                SailFactory factory = (SailFactory)SailRegistry.getInstance().get((Object)typeLit.getLabel());
                if (factory == null) {
                    throw new RepositoryConfigException("Unsupported Sail type: " + typeLit.getLabel());
                }
                this.sailImplConfig = factory.getConfig();
                this.sailImplConfig.parse(graph, sailImplNode);
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
        catch (SailConfigException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

