/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.text.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.ListBindingSet;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserBase;

public class SPARQLResultsCSVParser
extends TupleQueryResultParserBase
implements TupleQueryResultParser {
    private List<String> bindingNames;

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.CSV;
    }

    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        String[] nextLine;
        CSVReader reader = new CSVReader((Reader)new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((nextLine = reader.readNext()) != null) {
            if (this.bindingNames == null) {
                this.bindingNames = Arrays.asList(nextLine);
                this.handler.startQueryResult(this.bindingNames);
                continue;
            }
            ArrayList<BNode> values = new ArrayList<BNode>();
            for (String valueString : nextLine) {
                BNode v = null;
                if (valueString.startsWith("_:")) {
                    v = this.valueFactory.createBNode(valueString.substring(2));
                } else if (!"".equals(valueString)) {
                    if (valueString.matches("^[\\+\\-]?[\\d\\.].*")) {
                        URI datatype = null;
                        if (XMLDatatypeUtil.isValidInteger((String)valueString)) {
                            datatype = XMLDatatypeUtil.isValidNegativeInteger((String)valueString) ? XMLSchema.NEGATIVE_INTEGER : XMLSchema.INTEGER;
                        } else if (XMLDatatypeUtil.isValidDecimal((String)valueString)) {
                            datatype = XMLSchema.DECIMAL;
                        } else if (XMLDatatypeUtil.isValidDouble((String)valueString)) {
                            datatype = XMLSchema.DOUBLE;
                        }
                        v = datatype != null ? this.valueFactory.createLiteral(valueString, datatype) : this.valueFactory.createLiteral(valueString);
                    } else {
                        try {
                            v = this.valueFactory.createURI(valueString);
                        }
                        catch (IllegalArgumentException e) {
                            v = this.valueFactory.createLiteral(valueString);
                        }
                    }
                }
                values.add(v);
            }
            ListBindingSet bindingSet = new ListBindingSet(this.bindingNames, values.toArray(new Value[values.size()]));
            this.handler.handleSolution((BindingSet)bindingSet);
        }
    }
}

