/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Mercator1SP;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stereographic
extends Projection {
    public static final Identifier STERE = new Identifier("EPSG", "9810", "Polar Stereographic", "STERE");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final double k0;
    protected final double a;
    protected final double e;
    protected final double e2;
    protected final double[] invcoeff;
    private double PI_2 = 1.5707963267948966;

    public Stereographic(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(STERE, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        this.e = ellipsoid.getEccentricity();
        this.e2 = ellipsoid.getSquareEccentricity();
        if (Math.abs(this.getLatitudeOfTrueScale()) != this.PI_2) {
            double lat_ts = this.getLatitudeOfTrueScale();
            double esints = this.e * Math.sin(lat_ts);
            double tf = Math.tan((this.PI_2 + lat_ts) / 2.0) / Math.pow((1.0 + esints) / (1.0 - esints), this.e / 2.0);
            double mf = Math.cos(lat_ts) / Math.sqrt(1.0 - esints * esints);
            this.k0 = mf * Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e)) / 2.0 / tf;
        } else {
            this.k0 = this.getScaleFactor();
        }
        this.a = this.getSemiMajorAxis();
        this.invcoeff = Mercator1SP.getInverseMercatorCoeff(ellipsoid);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.AZIMUTHAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double lon = coord[1];
        double lat = coord[0];
        double esin = this.e * Math.sin(lat);
        double t = this.lat0 < 0.0 ? Math.tan((this.PI_2 + lat) / 2.0) / Math.pow((1.0 + esin) / (1.0 - esin), this.e / 2.0) : Math.tan((this.PI_2 - lat) / 2.0) * Math.pow((1.0 + esin) / (1.0 - esin), this.e / 2.0);
        double rho = 2.0 * this.a * this.k0 * t / Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e));
        double dE = rho * Math.sin(lon - this.lon0);
        double dN = rho * Math.cos(lon - this.lon0);
        coord[0] = this.FE + dE;
        coord[1] = this.lat0 < 0.0 ? this.FN + dN : this.FN - dN;
        return coord;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new Stereographic(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double rho = Math.sqrt((coord[0] - this.FE) * (coord[0] - this.FE) + (coord[1] - this.FN) * (coord[1] - this.FN));
                double t = rho * Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e)) / 2.0 / this.a / this.k0;
                double ki = this.lat0 > 0.0 ? 1.5707963267948966 - 2.0 * Math.atan(t) : 2.0 * Math.atan(t) - 1.5707963267948966;
                double lat = ki;
                for (int i = 1; i < 5; ++i) {
                    lat += this.invcoeff[i] * Math.sin((double)(2 * i) * ki);
                }
                coord[1] = this.lat0 < 0.0 ? this.lon0 + Math.atan2(coord[0] - this.FE, coord[1] - this.FN) : this.lon0 + Math.atan2(coord[0] - this.FE, this.FN - coord[1]);
                coord[0] = lat;
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return Stereographic.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return Stereographic.this.toString() + " inverse";
            }
        };
    }
}

