/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.manager;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.httpclient.HttpException;
import org.openrdf.http.client.SesameHTTPClient;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.util.Literals;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigUtil;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.repository.manager.RepositoryInfo;
import org.openrdf.repository.manager.RepositoryManager;

public class RemoteRepositoryManager
extends RepositoryManager {
    private String serverURL;
    private String username;
    private String password;

    public static RemoteRepositoryManager getInstance(String serverURL) throws RepositoryException {
        RemoteRepositoryManager manager = new RemoteRepositoryManager(serverURL);
        manager.initialize();
        return manager;
    }

    public static RemoteRepositoryManager getInstance(String serverURL, String username, String password) throws RepositoryException {
        RemoteRepositoryManager manager = new RemoteRepositoryManager(serverURL);
        manager.setUsernameAndPassword(username, password);
        manager.initialize();
        return manager;
    }

    public RemoteRepositoryManager(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    protected Repository createSystemRepository() throws RepositoryException {
        HTTPRepository systemRepository = new HTTPRepository(this.serverURL, "SYSTEM");
        systemRepository.setUsernameAndPassword(this.username, this.password);
        systemRepository.initialize();
        return systemRepository;
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        return new URL(this.serverURL);
    }

    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    protected Repository createRepository(String id) throws RepositoryConfigException, RepositoryException {
        HTTPRepository result = null;
        if (RepositoryConfigUtil.hasRepositoryConfig((Repository)this.getSystemRepository(), (String)id)) {
            result = new HTTPRepository(this.serverURL, id);
            result.setUsernameAndPassword(this.username, this.password);
            result.initialize();
        }
        return result;
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String id) throws RepositoryException {
        for (RepositoryInfo repInfo : this.getAllRepositoryInfos()) {
            if (!repInfo.getId().equals(id)) continue;
            return repInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RepositoryInfo> getAllRepositoryInfos(boolean skipSystemRepo) throws RepositoryException {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        try {
            SesameHTTPClient httpClient = new SesameHTTPClient();
            httpClient.setRepository(this.serverURL, null);
            httpClient.setUsernameAndPassword(this.username, this.password);
            try {
                TupleQueryResult responseFromServer = httpClient.getRepositoryList();
                while (responseFromServer.hasNext()) {
                    BindingSet bindingSet = (BindingSet)responseFromServer.next();
                    RepositoryInfo repInfo = new RepositoryInfo();
                    String id = Literals.getLabel((Value)bindingSet.getValue("id"), null);
                    if (skipSystemRepo && id.equals("SYSTEM")) continue;
                    Value uri = bindingSet.getValue("uri");
                    String description = Literals.getLabel((Value)bindingSet.getValue("title"), null);
                    boolean readable = Literals.getBooleanValue((Value)bindingSet.getValue("readable"), (boolean)false);
                    boolean writable = Literals.getBooleanValue((Value)bindingSet.getValue("writable"), (boolean)false);
                    if (uri instanceof URI) {
                        try {
                            repInfo.setLocation(new URL(uri.toString()));
                        }
                        catch (MalformedURLException e) {
                            this.logger.warn("Server reported malformed repository URL: {}", (Object)uri);
                        }
                    }
                    repInfo.setId(id);
                    repInfo.setDescription(description);
                    repInfo.setReadable(readable);
                    repInfo.setWritable(writable);
                    result.add(repInfo);
                }
            }
            finally {
                httpClient.shutDown();
            }
        }
        catch (IOException ioe) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)ioe);
            throw new RepositoryException((Throwable)ioe);
        }
        catch (QueryEvaluationException qee) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)qee);
            throw new RepositoryException((Throwable)qee);
        }
        catch (UnauthorizedException ue) {
            this.logger.warn("Not authorized to retrieve list of repositories", (Throwable)ue);
            throw new RepositoryException((Throwable)ue);
        }
        catch (RepositoryException re) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)re);
            throw re;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        boolean existingRepo = RepositoryConfigUtil.hasRepositoryConfig((Repository)this.getSystemRepository(), (String)repositoryID);
        if (existingRepo) {
            SesameHTTPClient httpClient = new SesameHTTPClient();
            try {
                httpClient.setServerURL(this.serverURL);
                httpClient.setUsernameAndPassword(this.username, this.password);
                try {
                    httpClient.deleteRepository(repositoryID);
                }
                catch (HttpException e) {
                    this.logger.warn("error while deleting remote repository", (Throwable)e);
                    throw new RepositoryConfigException((Throwable)e);
                }
                catch (IOException e) {
                    this.logger.warn("error while deleting remote repository", (Throwable)e);
                    throw new RepositoryConfigException((Throwable)e);
                }
            }
            finally {
                httpClient.shutDown();
            }
        }
        return existingRepo;
    }

    @Override
    protected void cleanUpRepository(String repositoryID) throws IOException {
    }
}

