/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.updatebuilder;

import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadHolder;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadIteratorBuilder;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.util.iterator.ExtendedIterator;

public class QBQuadHolder
implements QuadHolder {
    private final AbstractQueryBuilder<?> qb;
    private Node defaultGraphName;

    public QBQuadHolder(Node graph, AbstractQueryBuilder<?> qb) {
        this.qb = qb;
        this.defaultGraphName = graph;
    }

    public QBQuadHolder(AbstractQueryBuilder<?> qb) {
        this(Quad.defaultGraphNodeGenerated, qb);
    }

    @Override
    public ExtendedIterator<Quad> getQuads() {
        Query q = this.qb.build();
        QuadIteratorBuilder builder = new QuadIteratorBuilder(this.defaultGraphName);
        q.getQueryPattern().visit((ElementVisitor)builder);
        return builder.iter;
    }

    @Override
    public QuadHolder setValues(Map<Var, Node> values) {
        this.qb.clearValues();
        for (Map.Entry<Var, Node> entry : values.entrySet()) {
            this.qb.setVar(entry.getKey(), entry.getValue());
        }
        return this;
    }
}

