/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;

public class AggregationHandler
implements Handler {
    private final Query query;
    private final Map<Var, ExprAggregator> aggMap;

    public AggregationHandler(Query query) {
        this.query = query;
        this.aggMap = new HashMap<Var, ExprAggregator>();
    }

    public AggregationHandler addAll(AggregationHandler handler) {
        for (ExprAggregator exprAggregator : handler.query.getAggregators()) {
            this.query.allocAggregate(exprAggregator.getAggregator());
        }
        for (Map.Entry entry : handler.aggMap.entrySet()) {
            this.aggMap.put((Var)entry.getKey(), (ExprAggregator)entry.getValue());
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public void setVars(Map<Var, Node> values) {
    }

    @Override
    public void build() {
        for (Map.Entry entry : this.query.getProject().getExprs().entrySet()) {
            if (!this.aggMap.containsKey(entry.getKey())) continue;
            entry.setValue(this.aggMap.get(entry.getKey()));
        }
    }

    public void add(Expr expr, Var var) {
        if (expr instanceof ExprAggregator) {
            ExprAggregator eAgg = (ExprAggregator)expr;
            Expr expr2 = this.query.allocAggregate(eAgg.getAggregator());
            this.aggMap.put(var, (ExprAggregator)expr2);
        }
    }
}

