/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

public abstract class BigdataGraphAtom {
    protected final String id;

    protected BigdataGraphAtom(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static class PropertyAtom
    extends BigdataGraphAtom {
        private final String key;
        private final Object val;

        public PropertyAtom(String id, String key, Object val) {
            super(id);
            this.key = key;
            this.val = val;
        }

        public String getKey() {
            return this.key;
        }

        public Object getVal() {
            return this.val;
        }

        public String toString() {
            return "PropertyAtom [id=" + this.id + ", key=" + this.key + ", val=" + this.val + "]";
        }
    }

    public static class EdgeLabelAtom
    extends BigdataGraphAtom {
        private final String label;

        public EdgeLabelAtom(String id, String label) {
            super(id);
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return "EdgeLabelAtom [id=" + this.id + ", label=" + this.label + "]";
        }
    }

    public static class EdgeAtom
    extends BigdataGraphAtom {
        private final String fromId;
        private final String toId;

        public EdgeAtom(String id, String fromId, String toId) {
            super(id);
            this.fromId = fromId;
            this.toId = toId;
        }

        public String getFromId() {
            return this.fromId;
        }

        public String getToId() {
            return this.toId;
        }

        public String toString() {
            return "EdgeAtom [id=" + this.id + ", from=" + this.fromId + ", to=" + this.toId + "]";
        }
    }

    public static class ExistenceAtom
    extends BigdataGraphAtom {
        private final ElementType type;

        public ExistenceAtom(String id, ElementType type) {
            super(id);
            this.type = type;
        }

        public ElementType getElementType() {
            return this.type;
        }

        public String toString() {
            return "ExistenceAtom [id=" + this.id + ", type=" + (Object)((Object)this.type) + "]";
        }
    }

    public static enum ElementType {
        VERTEX,
        EDGE;

    }
}

