/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.protocol.error;

import org.openrdf.http.protocol.error.ErrorType;

public class ErrorInfo {
    private final ErrorType errorType;
    private final String errMSg;

    public ErrorInfo(String errMsg) {
        this(null, errMsg);
    }

    public ErrorInfo(ErrorType errorType, String errMsg) {
        assert (errMsg != null) : "errMsg must not be null";
        this.errorType = errorType;
        this.errMSg = errMsg;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errMSg;
    }

    public String toString() {
        if (this.errorType != null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.errorType);
            sb.append(": ");
            sb.append(this.errMSg);
            return sb.toString();
        }
        return this.errMSg;
    }

    public static ErrorInfo parse(String errInfoString) {
        String label;
        String message = errInfoString;
        ErrorType errorType = null;
        int colonIdx = errInfoString.indexOf(58);
        if (colonIdx >= 0 && (errorType = ErrorType.forLabel(label = errInfoString.substring(0, colonIdx).trim())) != null) {
            message = errInfoString.substring(colonIdx + 1);
        }
        return new ErrorInfo(errorType, message.trim());
    }
}

