/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterAddTripleTerm;
import org.apache.jena.sparql.engine.iterator.QueryIterTriplePattern;
import org.apache.jena.sparql.util.Context;

public class RX {
    public static QueryIterator rdfStarTriple(QueryIterator chain, Triple triple, ExecutionContext execCxt) {
        if (!RX.tripleHasNodeTriple(triple)) {
            return RX.matchData(chain, triple, execCxt);
        }
        return RX.rdfStarTripleSub(chain, triple, execCxt);
    }

    private static VarAlloc varAlloc(ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        VarAlloc varAlloc = VarAlloc.get(context2, ARQConstants.sysVarAllocRDFStar);
        if (varAlloc == null) {
            varAlloc = new VarAlloc("~");
            context2.set(ARQConstants.sysVarAllocRDFStar, varAlloc);
        }
        return varAlloc;
    }

    private static QueryIterator rdfStarTripleSub(QueryIterator chain, Triple triple, ExecutionContext execCxt) {
        Pair<QueryIterator, Triple> pair = RX.preprocessForTripleTerms(chain, triple, execCxt);
        QueryIterator chain2 = RX.matchData((QueryIterator)pair.getLeft(), (Triple)pair.getRight(), execCxt);
        return chain2;
    }

    public static QueryIterator matchTripleStar(QueryIterator chain, Var var, Triple triple, ExecutionContext execCxt) {
        if (RX.tripleHasNodeTriple(triple)) {
            Pair<QueryIterator, Triple> pair = RX.preprocessForTripleTerms(chain, triple, execCxt);
            chain = (QueryIterator)pair.getLeft();
            triple = (Triple)pair.getRight();
        }
        QueryIterator qIter = RX.bindTripleTerm(chain, var, triple, execCxt);
        return qIter;
    }

    private static Pair<QueryIterator, Triple> preprocessForTripleTerms(QueryIterator chain, Triple patternTriple, ExecutionContext execCxt) {
        Triple tripleTerm;
        Var var;
        Triple t2;
        Node s = patternTriple.getSubject();
        Node p = patternTriple.getPredicate();
        Node o = patternTriple.getObject();
        Object s1 = null;
        Object o1 = null;
        if (s.isNodeTriple() && !s.isConcrete()) {
            t2 = Node_Triple.triple((Node)s);
            var = RX.varAlloc(execCxt).allocVar();
            tripleTerm = Triple.create((Node)t2.getSubject(), (Node)t2.getPredicate(), (Node)t2.getObject());
            chain = RX.matchTripleStar(chain, var, tripleTerm, execCxt);
            s1 = var;
        }
        if (o.isNodeTriple() && !o.isConcrete()) {
            t2 = Node_Triple.triple((Node)o);
            var = RX.varAlloc(execCxt).allocVar();
            tripleTerm = Triple.create((Node)t2.getSubject(), (Node)t2.getPredicate(), (Node)t2.getObject());
            chain = RX.matchTripleStar(chain, var, tripleTerm, execCxt);
            o1 = var;
        }
        if (s1 == null && o1 == null) {
            return Pair.create((Object)chain, (Object)patternTriple);
        }
        if (s1 == null) {
            s1 = s;
        }
        if (o1 == null) {
            o1 = o;
        }
        Triple triple1 = Triple.create((Node)s1, (Node)p, (Node)o1);
        return Pair.create((Object)chain, (Object)triple1);
    }

    private static QueryIterator bindTripleTerm(QueryIterator chain, Var var, Triple pattern, ExecutionContext execCxt) {
        QueryIterator qIter = RX.matchData(chain, pattern, execCxt);
        QueryIterAddTripleTerm qIter2 = new QueryIterAddTripleTerm(qIter, var, pattern, execCxt);
        return qIter2;
    }

    private static QueryIterator matchData(QueryIterator chain, Triple pattern, ExecutionContext execCxt) {
        return new QueryIterTriplePattern(chain, pattern, execCxt);
    }

    private static boolean tripleHasNodeTriple(Triple triple) {
        return triple.getSubject().isNodeTriple() || triple.getObject().isNodeTriple();
    }
}

