/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system.stream;

import java.util.Locale;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.system.stream.Locator;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.util.FileUtils;
import org.slf4j.Logger;

public abstract class LocatorURL
implements Locator {
    private final String[] schemeNames;

    protected LocatorURL(String[] sNames) {
        this.schemeNames = sNames;
    }

    protected abstract Logger log();

    @Override
    public TypedInputStream open(String uri) {
        if (!this.acceptByScheme(uri)) {
            if (StreamManager.logAllLookups && this.log().isTraceEnabled()) {
                this.log().trace("Not found : " + uri);
            }
            return null;
        }
        return this.performOpen(uri);
    }

    protected abstract TypedInputStream performOpen(String var1);

    protected boolean acceptByScheme(String filenameOrURI) {
        String uriSchemeName = FileUtils.getScheme((String)filenameOrURI);
        if (uriSchemeName == null) {
            return false;
        }
        uriSchemeName = uriSchemeName.toLowerCase(Locale.ROOT);
        for (String schemeName : this.schemeNames) {
            if (!uriSchemeName.equals(schemeName)) continue;
            return true;
        }
        return false;
    }

    public abstract int hashCode();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

