/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public interface Graph {
    public static final Graph emptyGraph = new GraphBase(){

        @Override
        public ExtendedIterator<Triple> graphBaseFind(Triple tm) {
            return NullIterator.instance();
        }
    };

    public boolean dependsOn(Graph var1);

    public TransactionHandler getTransactionHandler();

    public Capabilities getCapabilities();

    public GraphEventManager getEventManager();

    @Deprecated
    public GraphStatisticsHandler getStatisticsHandler();

    public PrefixMapping getPrefixMapping();

    public void add(Triple var1) throws AddDeniedException;

    public void delete(Triple var1) throws DeleteDeniedException;

    public ExtendedIterator<Triple> find(Triple var1);

    public ExtendedIterator<Triple> find(Node var1, Node var2, Node var3);

    default public ExtendedIterator<Triple> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY);
    }

    public boolean isIsomorphicWith(Graph var1);

    public boolean contains(Node var1, Node var2, Node var3);

    public boolean contains(Triple var1);

    public void clear();

    public void remove(Node var1, Node var2, Node var3);

    public void close();

    public boolean isEmpty();

    public int size();

    public boolean isClosed();
}

