/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamDocumentSourceBase
extends OWLOntologyDocumentSourceBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamDocumentSourceBase.class);
    @Nullable
    protected byte[] byteBuffer;
    private Charset encoding = StandardCharsets.UTF_8;
    private boolean streamAvailable = false;

    public StreamDocumentSourceBase(InputStream stream, IRI documentIRI, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(documentIRI, format, mime);
        this.readIntoBuffer(OWLAPIPreconditions.checkNotNull(stream, "stream cannot be null"));
        this.streamAvailable = true;
    }

    public StreamDocumentSourceBase(Reader stream, IRI documentIRI, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(documentIRI, format, mime);
        OWLAPIPreconditions.checkNotNull(stream, "stream cannot be null");
        if (stream instanceof InputStreamReader) {
            this.encoding = Charset.forName(((InputStreamReader)stream).getEncoding());
        }
        this.readIntoBuffer(stream);
        this.streamAvailable = false;
    }

    protected StreamDocumentSourceBase(InputStream stream, String prefix, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(prefix, format, mime);
        this.readIntoBuffer(OWLAPIPreconditions.checkNotNull(stream, "stream cannot be null"));
        this.streamAvailable = true;
    }

    protected StreamDocumentSourceBase(Reader stream, String prefix, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(prefix, format, mime);
        OWLAPIPreconditions.checkNotNull(stream, "stream cannot be null");
        if (stream instanceof InputStreamReader) {
            this.encoding = Charset.forName(((InputStreamReader)stream).getEncoding());
        }
        this.readIntoBuffer(stream);
        this.streamAvailable = false;
    }

    private void readIntoBuffer(InputStream reader) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            IOUtils.copy((InputStream)reader, (OutputStream)out);
            out.finish();
            out.flush();
            this.byteBuffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void readIntoBuffer(Reader reader) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            IOUtils.copy((Reader)reader, (Writer)writer);
            writer.flush();
            out.finish();
            out.flush();
            this.byteBuffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public Optional<InputStream> getInputStream() {
        if (!this.streamAvailable) {
            return OWLAPIPreconditions.emptyOptional();
        }
        try {
            return OWLAPIPreconditions.optional(new GZIPInputStream(new ByteArrayInputStream(this.byteBuffer)));
        }
        catch (IOException e) {
            LOGGER.error("Buffer cannot be opened", (Throwable)e);
            this.failedOnStreams.set(true);
            return OWLAPIPreconditions.emptyOptional();
        }
    }

    @Override
    public Optional<Reader> getReader() {
        if (this.streamAvailable) {
            return OWLAPIPreconditions.emptyOptional();
        }
        try {
            return OWLAPIPreconditions.optional(new InputStreamReader(DocumentSources.wrap(new GZIPInputStream(new ByteArrayInputStream(this.byteBuffer))), this.encoding));
        }
        catch (IOException e) {
            LOGGER.error("Buffer cannot be opened", (Throwable)e);
            this.failedOnStreams.set(true);
            return OWLAPIPreconditions.emptyOptional();
        }
    }
}

