/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.Iterator;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.factplusplusad.CardinalityEvaluatorBase;
import uk.ac.manchester.cs.factplusplusad.Signature;

class LowerBoundDirectEvaluator
extends CardinalityEvaluatorBase {
    LowerBoundDirectEvaluator(Signature s) {
        super(s);
    }

    @Override
    int getNoneValue() {
        return 0;
    }

    @Override
    int getAllValue() {
        return -1;
    }

    @Override
    int getOneNoneLower(boolean v) {
        return v ? 1 : this.getNoneValue();
    }

    @Override
    int getEntityValue(OWLEntity entity) {
        if (entity.isTopEntity()) {
            if (OWLRDFVocabulary.OWL_THING.getIRI().equals((Object)entity.getIRI())) {
                return 1;
            }
            return this.anyLowerValue();
        }
        if (entity.isBottomEntity()) {
            return this.noLowerValue();
        }
        return this.getOneNoneLower(this.topCLocal() && this.nc(entity));
    }

    @Override
    int getForallValue(OWLPropertyExpression r, OWLPropertyRange c) {
        return this.getOneNoneLower(this.isBotEquivalent((OWLObject)r) || this.isUpperLE(this.getUpperBoundComplement((OWLObject)c), 0));
    }

    @Override
    int getMinValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        if (m == 0) {
            return this.anyLowerValue();
        }
        if (!this.isTopEquivalent((OWLObject)r)) {
            return this.noLowerValue();
        }
        return this.isLowerGE(this.getLowerBoundDirect((OWLObject)c), m) ? m : this.noLowerValue();
    }

    @Override
    int getMaxValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        if (this.isBotEquivalent((OWLObject)r)) {
            return 1;
        }
        return this.getOneNoneLower(this.isUpperLE(this.getUpperBoundDirect((OWLObject)c), m));
    }

    @Override
    int getExactValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        int min = this.getMinValue(m, r, c);
        int max = this.getMaxValue(m, r, c);
        if (min == this.noLowerValue() || max == this.noLowerValue()) {
            return this.noLowerValue();
        }
        if (min == this.anyLowerValue()) {
            return max;
        }
        if (max == this.anyLowerValue()) {
            return min;
        }
        return Math.min(min, max);
    }

    <C extends OWLObject> int getAndValue(HasOperands<C> expr) {
        boolean foundC = false;
        int foundM = 0;
        int mMax = 0;
        int kMax = 0;
        int sumK = 0;
        Iterator it = expr.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            int m = this.getLowerBoundDirect(p);
            int k = this.getUpperBoundComplement(p);
            if (m == this.noLowerValue() && k == this.noUpperValue()) {
                return this.noLowerValue();
            }
            if (m == this.noLowerValue()) {
                sumK += k;
                continue;
            }
            if (k == this.noUpperValue()) {
                if (foundC) {
                    return this.noLowerValue();
                }
                foundC = true;
                foundM = m;
                continue;
            }
            sumK += k;
            if (k + m <= kMax + mMax) continue;
            kMax = k;
            mMax = m;
        }
        if (foundC) {
            return (foundM -= sumK) > 0 ? foundM : this.noLowerValue();
        }
        return (mMax -= (sumK -= kMax)) > 0 ? mMax : this.noLowerValue();
    }

    <C extends OWLObject> int getOrValue(HasOperands<C> expr) {
        int max = this.noLowerValue();
        Iterator it = expr.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            int n = this.getLowerBoundDirect(p);
            if (n == this.anyLowerValue()) {
                return this.anyLowerValue();
            }
            max = Math.max(max, n);
        }
        return max;
    }

    public void visit(OWLObjectComplementOf expr) {
        this.value = this.getLowerBoundComplement(expr.getOperand());
    }

    public void visit(OWLObjectIntersectionOf expr) {
        this.value = this.getAndValue((HasOperands)expr);
    }

    public void visit(OWLObjectUnionOf expr) {
        this.value = this.getOrValue((HasOperands)expr);
    }

    public void visit(OWLObjectOneOf expr) {
        this.value = this.getOneNoneLower(expr.individuals().count() > 0L);
    }

    public void visit(OWLObjectHasSelf expr) {
        this.value = this.getOneNoneLower(this.isTopEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLObjectHasValue expr) {
        this.value = this.getOneNoneLower(this.isTopEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLDataHasValue expr) {
        this.value = this.getOneNoneLower(this.isTopEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLObjectInverseOf expr) {
        this.value = this.getLowerBoundDirect((OWLObject)expr.getInverseProperty());
    }

    public void visit(OWLSubPropertyChainOfAxiom expr) {
        for (OWLObjectPropertyExpression p : expr.getPropertyChain()) {
            if (this.isTopEquivalent((OWLObject)p)) continue;
            this.value = this.noLowerValue();
            return;
        }
        this.value = this.anyLowerValue();
    }

    public void visit(OWLDatatype o) {
        this.value = this.noLowerValue();
    }

    public void visit(OWLDatatypeRestriction o) {
        this.value = this.noLowerValue();
    }

    public void visit(OWLLiteral o) {
        this.value = this.noLowerValue();
    }

    public void visit(OWLDataComplementOf expr) {
        this.value = this.getLowerBoundComplement((OWLObject)expr.getDataRange());
    }

    public void visit(OWLDataIntersectionOf expr) {
        this.value = this.getAndValue((HasOperands)expr);
    }

    public void visit(OWLDataUnionOf expr) {
        this.value = this.getOrValue((HasOperands)expr);
    }

    public void visit(OWLDataOneOf expr) {
        this.value = this.getOneNoneLower(expr.values().count() > 0L);
    }
}

