/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.bop.IElement;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.striterator.IKeyOrder;

public abstract class AbstractKeyOrder<E>
implements IKeyOrder<E> {
    @Override
    public byte[] getKey(IKeyBuilder keyBuilder, E element) {
        keyBuilder.reset();
        int keyArity = this.getKeyArity();
        for (int i = 0; i < keyArity; ++i) {
            this.appendKeyComponent(keyBuilder, i, ((IElement)element).get(this.getKeyOrder(i)));
        }
        return keyBuilder.getKey();
    }

    @Override
    public byte[] getFromKey(IKeyBuilder keyBuilder, IPredicate<E> predicate) {
        IVariableOrConstant term;
        keyBuilder.reset();
        int keyArity = this.getKeyArity();
        boolean noneBound = true;
        for (int i = 0; i < keyArity && (term = predicate.get(this.getKeyOrder(i))) != null && !term.isVar(); ++i) {
            this.appendKeyComponent(keyBuilder, i, term.get());
            noneBound = false;
        }
        byte[] key = noneBound ? null : keyBuilder.getKey();
        return key;
    }

    @Override
    public byte[] getToKey(IKeyBuilder keyBuilder, IPredicate<E> predicate) {
        IVariableOrConstant term;
        keyBuilder.reset();
        int keyArity = this.getKeyArity();
        boolean noneBound = true;
        for (int i = 0; i < keyArity && (term = predicate.get(this.getKeyOrder(i))) != null && !term.isVar(); ++i) {
            this.appendKeyComponent(keyBuilder, i, term.get());
            noneBound = false;
        }
        byte[] key = noneBound ? null : keyBuilder.getKey();
        return key == null ? null : SuccessorUtil.successor(key);
    }

    protected void appendKeyComponent(IKeyBuilder keyBuilder, int index, Object keyComponent) {
        keyBuilder.append(keyComponent);
    }
}

