/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.sparse.KeyType;
import com.bigdata.sparse.NameChecker;
import com.bigdata.sparse.SparseRowStore;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class Schema
implements Externalizable {
    private static final long serialVersionUID = -7619134292028385179L;
    private String name;
    private String primaryKey;
    private KeyType primaryKeyType;
    private transient byte[] schemaBytes;
    private static final transient short VERSION0 = 0;
    private static final IKeyBuilder _keyBuilder = KeyBuilder.newUnicodeInstance();

    public Schema() {
    }

    public Schema(String name, String primaryKey, KeyType primaryKeyType) {
        NameChecker.assertSchemaName(name);
        NameChecker.assertColumnName(primaryKey);
        if (primaryKeyType == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.primaryKey = primaryKey;
        this.primaryKeyType = primaryKeyType;
        this.getSchemaBytes();
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryKeyName() {
        return this.primaryKey;
    }

    public KeyType getPrimaryKeyType() {
        return this.primaryKeyType;
    }

    protected final byte[] getSchemaBytes() {
        if (this.schemaBytes == null) {
            if (SparseRowStore.schemaNameUnicodeClean) {
                try {
                    this.schemaBytes = this.name.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.schemaBytes = Schema.asSortKey(this.name);
            }
        }
        return this.schemaBytes;
    }

    protected final IKeyBuilder appendPrimaryKey(IKeyBuilder keyBuilder, Object v, boolean successor) {
        KeyType keyType = this.getPrimaryKeyType();
        if (successor) {
            switch (keyType) {
                case Integer: {
                    return keyBuilder.append(this.successor(keyBuilder, ((Number)v).intValue()));
                }
                case Long: {
                    return keyBuilder.append(this.successor(keyBuilder, ((Number)v).longValue()));
                }
                case Float: {
                    return keyBuilder.append(this.successor(keyBuilder, Float.valueOf(((Number)v).floatValue())));
                }
                case Double: {
                    return keyBuilder.append(this.successor(keyBuilder, ((Number)v).doubleValue()));
                }
                case Unicode: {
                    String tmp = v.toString();
                    if (SparseRowStore.primaryKeyUnicodeClean) {
                        try {
                            keyBuilder.append(SuccessorUtil.successor(tmp.getBytes("UTF-8"))).appendNul();
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        keyBuilder.appendText(tmp, true, true).appendNul();
                    }
                    return keyBuilder;
                }
                case ASCII: {
                    return keyBuilder.appendText(v.toString(), false, true).appendNul();
                }
                case Date: {
                    return keyBuilder.append(this.successor(keyBuilder, ((Date)v).getTime()));
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (keyType) {
            case Integer: {
                return keyBuilder.append(((Number)v).intValue());
            }
            case Long: {
                return keyBuilder.append(((Number)v).longValue());
            }
            case Float: {
                return keyBuilder.append(((Number)v).floatValue());
            }
            case Double: {
                return keyBuilder.append(((Number)v).doubleValue());
            }
            case Unicode: {
                String tmp = v.toString();
                if (SparseRowStore.primaryKeyUnicodeClean) {
                    try {
                        keyBuilder.append(tmp.getBytes("UTF-8")).appendNul();
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    keyBuilder.appendText(v.toString(), true, false).appendNul();
                }
                return keyBuilder;
            }
            case ASCII: {
                return keyBuilder.appendText(v.toString(), false, false).appendNul();
            }
            case Date: {
                return keyBuilder.append(((Date)v).getTime());
            }
        }
        throw new UnsupportedOperationException();
    }

    private final Object successor(IKeyBuilder keyBuilder, Object v) {
        KeyType keyType = this.getPrimaryKeyType();
        switch (keyType) {
            case Integer: {
                return SuccessorUtil.successor(((Number)v).intValue());
            }
            case Long: {
                return SuccessorUtil.successor(((Number)v).longValue());
            }
            case Float: {
                return Float.valueOf(SuccessorUtil.successor(((Number)v).floatValue()));
            }
            case Double: {
                return SuccessorUtil.successor(((Number)v).doubleValue());
            }
            case Unicode: 
            case ASCII: {
                throw new UnsupportedOperationException();
            }
            case Date: {
                return SuccessorUtil.successor(((Date)v).getTime());
            }
        }
        throw new UnsupportedOperationException();
    }

    protected final IKeyBuilder fromKey(IKeyBuilder keyBuilder, Object primaryKey) {
        keyBuilder.reset();
        keyBuilder.append(this.getSchemaBytes());
        keyBuilder.appendSigned(this.primaryKeyType.getByteCode());
        keyBuilder.appendNul();
        if (primaryKey != null) {
            this.appendPrimaryKey(keyBuilder, primaryKey, false);
        }
        return keyBuilder;
    }

    public final byte[] getPrefix(IKeyBuilder keyBuilder, Object primaryKey) {
        return this.fromKey(keyBuilder, primaryKey).getKey();
    }

    public byte[] getKey(IKeyBuilder keyBuilder, Object primaryKey, String col, long timestamp) {
        if (keyBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (primaryKey == null) {
            throw new IllegalArgumentException();
        }
        NameChecker.assertColumnName(col);
        this.fromKey(keyBuilder, primaryKey);
        try {
            keyBuilder.append(col.getBytes("UTF-8")).appendNul();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        keyBuilder.append(timestamp);
        byte[] key = keyBuilder.getKey();
        return key;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version != 0) {
            throw new IOException("Unknown version=" + version);
        }
        this.name = in.readUTF();
        this.primaryKey = in.readUTF();
        this.primaryKeyType = KeyType.getKeyType(in.readByte());
        this.getSchemaBytes();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeUTF(this.primaryKey);
        out.writeByte(this.primaryKeyType.getByteCode());
    }

    public String toString() {
        return "Schema{name=" + this.getName() + ",primaryKeyName=" + this.getPrimaryKeyName() + ",primaryKeyType=" + (Object)((Object)this.getPrimaryKeyType()) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] asSortKey(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        IKeyBuilder iKeyBuilder = _keyBuilder;
        synchronized (iKeyBuilder) {
            return _keyBuilder.getSortKey(val);
        }
    }
}

