/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.rdf.internal.impl.extensions.GeoSpatialLiteralExtension;
import java.util.ArrayList;

public class GeoSpatialConfig {
    private static GeoSpatialConfig instance;
    private static final String COMPONENT_SEPARATOR = ";";
    private static final String FIELD_SEPARATOR = "#";
    private GeoSpatialLiteralExtension.SchemaDescription schemaDescription;

    private GeoSpatialConfig() {
        this.init(null);
    }

    public static GeoSpatialConfig getInstance() {
        if (instance == null) {
            instance = new GeoSpatialConfig();
        }
        return instance;
    }

    public void init(String initStringSchemaDescription) {
        this.initSchemaDescription(initStringSchemaDescription);
    }

    public GeoSpatialLiteralExtension.SchemaDescription getSchemaDescription() {
        return this.schemaDescription;
    }

    private void initSchemaDescription(String initString) {
        if (initString == null || initString.isEmpty()) {
            this.schemaDescription = this.defaultSchemaDescription();
        } else {
            ArrayList<GeoSpatialLiteralExtension.SchemaFieldDescription> sfd = new ArrayList<GeoSpatialLiteralExtension.SchemaFieldDescription>();
            String[] components = initString.split(COMPONENT_SEPARATOR);
            for (int i = 0; i < components.length; ++i) {
                Long precision;
                GeoSpatialLiteralExtension.SchemaFieldDescription.Datatype datatype;
                String field2Str;
                String component = components[i].trim();
                String[] fields = component.split(FIELD_SEPARATOR);
                if (fields.length < 2 || fields.length > 3) {
                    throw new IllegalArgumentException("Invalid number of fields in component #" + i + ": " + fields.length);
                }
                String field0Str = fields[0].trim();
                String field1Str = fields[1].trim();
                String string = field2Str = fields.length == 3 ? fields[2] : null;
                if (field0Str.equalsIgnoreCase("DOUBLE")) {
                    datatype = GeoSpatialLiteralExtension.SchemaFieldDescription.Datatype.DOUBLE;
                } else if (field0Str.equalsIgnoreCase("LONG")) {
                    datatype = GeoSpatialLiteralExtension.SchemaFieldDescription.Datatype.LONG;
                } else {
                    throw new IllegalArgumentException("First field must be DOUBLE or LONG, but is: " + field0Str);
                }
                try {
                    precision = Long.valueOf(field1Str);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Second field must be an integer value, but is: " + field1Str);
                }
                Long minValue = field2Str == null ? null : Long.valueOf(field2Str);
                sfd.add(new GeoSpatialLiteralExtension.SchemaFieldDescription(datatype, precision, minValue));
            }
            this.schemaDescription = new GeoSpatialLiteralExtension.SchemaDescription(sfd);
        }
    }

    private GeoSpatialLiteralExtension.SchemaDescription defaultSchemaDescription() {
        ArrayList<GeoSpatialLiteralExtension.SchemaFieldDescription> sfd = new ArrayList<GeoSpatialLiteralExtension.SchemaFieldDescription>();
        sfd.add(new GeoSpatialLiteralExtension.SchemaFieldDescription(GeoSpatialLiteralExtension.SchemaFieldDescription.Datatype.DOUBLE, 100000L));
        sfd.add(new GeoSpatialLiteralExtension.SchemaFieldDescription(GeoSpatialLiteralExtension.SchemaFieldDescription.Datatype.DOUBLE, 100000L));
        sfd.add(new GeoSpatialLiteralExtension.SchemaFieldDescription(GeoSpatialLiteralExtension.SchemaFieldDescription.Datatype.LONG, 1L));
        return new GeoSpatialLiteralExtension.SchemaDescription(sfd);
    }
}

