/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.search.IAnalyzerFactory;
import com.bigdata.search.LanguageRange;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;

class ConfiguredAnalyzerFactory
implements IAnalyzerFactory {
    private final AnalyzerPair[] config;
    private final Map<String, AnalyzerPair> langTag2AnalyzerPair = new ConcurrentHashMap<String, AnalyzerPair>();
    private static final int MAX_LANG_CACHE_SIZE = 500;
    private final String defaultLanguage;

    public ConfiguredAnalyzerFactory(AnalyzerPair[] config, String defaultLanguage) {
        this.config = config;
        this.defaultLanguage = defaultLanguage;
    }

    private String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public Analyzer getAnalyzer(String languageCode, boolean filterStopwords) {
        AnalyzerPair pair;
        if (languageCode == null || languageCode.equals("")) {
            languageCode = this.getDefaultLanguage();
        }
        if ((pair = this.langTag2AnalyzerPair.get(languageCode)) == null) {
            pair = this.lookupPair(languageCode);
            if (this.langTag2AnalyzerPair.size() == 500) {
                this.langTag2AnalyzerPair.clear();
            }
            this.langTag2AnalyzerPair.put(languageCode, pair);
        }
        return pair.getAnalyzer(filterStopwords);
    }

    private AnalyzerPair lookupPair(String languageCode) {
        String[] language = languageCode.split("-");
        for (AnalyzerPair p : this.config) {
            if (!p.extendedFilterMatch(language)) continue;
            return p;
        }
        throw new RuntimeException("Impossible - supposedly - did not match '*'");
    }

    protected static class AnalyzerPair
    implements Comparable<AnalyzerPair> {
        final LanguageRange range;
        private final Analyzer withStopWords;
        private final Analyzer withoutStopWords;

        public Analyzer getAnalyzer(boolean filterStopwords) {
            return filterStopwords ? this.withStopWords : this.withoutStopWords;
        }

        public boolean extendedFilterMatch(String[] language) {
            return this.range.extendedFilterMatch(language);
        }

        AnalyzerPair(String range, Analyzer withStopWords, Analyzer withOutStopWords) {
            this.range = new LanguageRange(range);
            this.withStopWords = withStopWords;
            this.withoutStopWords = withOutStopWords;
        }

        AnalyzerPair(String range, AnalyzerPair copyMe) {
            this(range, copyMe.withStopWords, copyMe.withoutStopWords);
        }

        public String toString() {
            return this.range.full + "=(" + this.withStopWords.getClass().getSimpleName() + ")";
        }

        @Override
        public int compareTo(AnalyzerPair o) {
            return this.range.compareTo(o.range);
        }
    }
}

