/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.IndexPartitionCause;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.resources.AbstractAtomicUpdateTask;
import com.bigdata.resources.AbstractPrepareTask;
import com.bigdata.resources.JoinResult;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.OverflowSubtaskEnum;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.StaleLocatorReason;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.DataService;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.util.BytesUtil;
import java.util.Arrays;

public class JoinIndexPartitionTask
extends AbstractPrepareTask<JoinResult> {
    protected final ViewMetadata[] vmd;

    protected JoinIndexPartitionTask(ResourceManager resourceManager, long lastCommitTime, String[] resources, ViewMetadata[] vmd) {
        super(resourceManager, TimestampUtility.asHistoricalRead(lastCommitTime), resources);
        if (vmd == null) {
            throw new IllegalArgumentException();
        }
        if (vmd.length != resources.length) {
            throw new IllegalArgumentException();
        }
        this.vmd = vmd;
    }

    @Override
    protected void clearRefs() {
        for (ViewMetadata t : this.vmd) {
            t.clearRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JoinResult doTask() throws Exception {
        Event e = new Event(this.resourceManager.getFederation(), new EventResource(this.vmd[0].indexMetadata), (Object)OverflowActionEnum.Join).start();
        e.addDetail("summary", (Object)((Object)OverflowActionEnum.Join) + "(" + Arrays.toString(this.getResource()) + ")");
        try {
            JoinResult result;
            try {
                if (this.resourceManager.isOverflowAllowed()) {
                    throw new IllegalStateException();
                }
                Object[] resources = this.getResource();
                IndexMetadata newMetadata = this.getIndex(resources[0]).getIndexMetadata().clone();
                if (newMetadata.getPartitionMetadata() == null) {
                    throw new RuntimeException("Not an index partition: " + resources[0]);
                }
                if (newMetadata.getPartitionMetadata().getSourcePartitionId() != -1) {
                    throw new IllegalStateException("Join not allowed during move: sourcePartitionId=" + newMetadata.getPartitionMetadata().getSourcePartitionId());
                }
                byte[] leftSeparator = newMetadata.getPartitionMetadata().getLeftSeparatorKey();
                newMetadata.setPartitionMetadata(null);
                BTree btree = BTree.create(this.resourceManager.getLiveJournal(), newMetadata);
                Object[] oldpmd = new LocalPartitionMetadata[resources.length];
                for (int i = 0; i < resources.length; ++i) {
                    String name = resources[i];
                    ILocalBTreeView src = this.getIndex(name);
                    IndexMetadata sourceIndexMetadata = src.getIndexMetadata();
                    if (!newMetadata.getIndexUUID().equals(sourceIndexMetadata.getIndexUUID())) {
                        throw new RuntimeException("Partition for the wrong index? : names=" + Arrays.toString(resources));
                    }
                    LocalPartitionMetadata pmd = sourceIndexMetadata.getPartitionMetadata();
                    if (pmd == null) {
                        throw new RuntimeException("Not an index partition: " + (String)resources[i]);
                    }
                    if (!BytesUtil.bytesEqual((byte[])leftSeparator, (byte[])pmd.getLeftSeparatorKey())) {
                        throw new RuntimeException("Partitions out of order: names=" + Arrays.toString(resources) + ", have=" + Arrays.toString(oldpmd) + ", found=" + pmd);
                    }
                    oldpmd[i] = pmd;
                    long ncopied = btree.rangeCopy(src, null, null, true);
                    if (INFO) {
                        log.info((Object)("Copied " + ncopied + " index entries from " + name));
                    }
                    leftSeparator = pmd.getRightSeparatorKey();
                }
                String scaleOutIndexName = newMetadata.getName();
                int partitionId = this.resourceManager.getFederation().getMetadataService().nextPartitionId(scaleOutIndexName);
                String summary = (Object)((Object)OverflowActionEnum.Join) + "(" + Arrays.toString(resources) + "->" + partitionId + ")";
                newMetadata.setPartitionMetadata(new LocalPartitionMetadata(partitionId, -1, oldpmd[0].getLeftSeparatorKey(), ((LocalPartitionMetadata)oldpmd[resources.length - 1]).getRightSeparatorKey(), new IResourceMetadata[]{this.getJournal().getResourceMetadata()}, IndexPartitionCause.join(this.resourceManager)));
                btree.setIndexMetadata(newMetadata.clone());
                long checkpointAddr = btree.writeCheckpoint();
                result = new JoinResult(DataService.getIndexPartitionName(scaleOutIndexName, partitionId), newMetadata, checkpointAddr, (String[])resources);
            }
            finally {
                this.clearRefs();
            }
            String[] names2 = new String[result.oldnames.length + 1];
            names2[0] = result.name;
            System.arraycopy(result.oldnames, 0, names2, 1, result.oldnames.length);
            AtomicUpdateJoinIndexPartition task = new AtomicUpdateJoinIndexPartition(this.resourceManager, names2, result, e.newSubEvent((Object)OverflowSubtaskEnum.AtomicUpdate));
            this.concurrencyManager.submit(task).get();
            JoinResult joinResult = result;
            return joinResult;
        }
        finally {
            e.end();
        }
    }

    protected static class AtomicUpdateJoinIndexPartition
    extends AbstractAtomicUpdateTask<Void> {
        private final JoinResult result;
        private final Event updateEvent;

        public AtomicUpdateJoinIndexPartition(ResourceManager resourceManager, String[] resource, JoinResult result, Event updateEvent) {
            super(resourceManager, 0L, resource);
            if (result == null) {
                throw new IllegalArgumentException();
            }
            if (updateEvent == null) {
                throw new IllegalArgumentException();
            }
            this.result = result;
            this.updateEvent = updateEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doTask() throws Exception {
            this.updateEvent.start();
            try {
                if (this.resourceManager.isOverflowAllowed()) {
                    throw new IllegalStateException();
                }
                BTree btree = BTree.load(this.resourceManager.getLiveJournal(), this.result.checkpointAddr, false);
                assert (btree != null);
                assert (!btree.isReadOnly());
                String scaleOutIndexName = btree.getIndexMetadata().getName();
                int njoined = this.result.oldnames.length;
                PartitionLocator[] oldLocators = new PartitionLocator[njoined];
                for (int i = 0; i < njoined; ++i) {
                    String name = this.result.oldnames[i];
                    ILocalBTreeView src = this.getIndex(name);
                    assert (src != null);
                    if (!btree.getIndexMetadata().getIndexUUID().equals(src.getIndexMetadata().getIndexUUID())) {
                        throw new AssertionError();
                    }
                    LocalPartitionMetadata pmd = src.getIndexMetadata().getPartitionMetadata();
                    oldLocators[i] = new PartitionLocator(pmd.getPartitionId(), this.resourceManager.getDataServiceUUID(), pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey());
                    btree.rangeCopy(src, null, null, false);
                    this.getJournal().dropIndex(name);
                }
                this.getJournal().registerIndex(this.result.name, btree);
                LocalPartitionMetadata pmd = btree.getIndexMetadata().getPartitionMetadata();
                assert (pmd != null);
                PartitionLocator newLocator = new PartitionLocator(pmd.getPartitionId(), this.resourceManager.getDataServiceUUID(), pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey());
                this.resourceManager.getFederation().getMetadataService().joinIndexPartition(scaleOutIndexName, oldLocators, newLocator);
                for (String name : this.result.oldnames) {
                    this.resourceManager.setIndexPartitionGone(name, StaleLocatorReason.Join);
                }
                this.resourceManager.overflowCounters.indexPartitionJoinCounter.incrementAndGet();
                Void void_ = null;
                return void_;
            }
            finally {
                this.updateEvent.end();
            }
        }
    }
}

