/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval.pipeline;

import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IRuleState;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.concurrent.atomic.AtomicLong;

public class JoinStats
implements Serializable {
    private static final long serialVersionUID = 9028650921831777131L;
    public final long startTime;
    public final int partitionId;
    public final int orderIndex;
    public int fanIn;
    public int fanOut;
    public int partitionCount;
    private transient IntSet partitionIds;
    public long bindingSetChunksIn;
    public long bindingSetsIn;
    public long accessPathCount;
    public long accessPathDups;
    public long chunkCount;
    public long elementCount;
    public long bindingSetsOut;
    public long bindingSetChunksOut;
    public AtomicLong mutationCount = new AtomicLong();
    private static final transient String sep = ", ";

    public JoinStats(int orderIndex) {
        this(-1, orderIndex);
    }

    public JoinStats(int partitionId, int orderIndex) {
        this.startTime = System.currentTimeMillis();
        this.partitionId = partitionId;
        this.orderIndex = orderIndex;
        this.fanOut = 0;
        this.fanIn = 0;
        this.partitionCount = partitionId == -1 ? 0 : 1;
        this.bindingSetsIn = 0L;
        this.bindingSetChunksIn = 0L;
        this.accessPathDups = 0L;
        this.accessPathCount = 0L;
        this.bindingSetsOut = 0L;
        this.elementCount = 0L;
        this.chunkCount = 0L;
        this.bindingSetChunksOut = 0L;
    }

    synchronized void add(JoinStats o) {
        if (this.orderIndex != o.orderIndex) {
            throw new IllegalArgumentException();
        }
        if (this.partitionIds == null) {
            this.partitionIds = new IntOpenHashSet();
        }
        if (this.partitionIds.add(o.partitionId)) {
            ++this.partitionCount;
        }
        if (o.fanIn > this.fanIn) {
            this.fanIn = o.fanIn;
        }
        if (o.fanOut > this.fanOut) {
            this.fanOut += o.fanOut;
        }
        this.bindingSetChunksIn += o.bindingSetChunksIn;
        this.bindingSetsIn += o.bindingSetsIn;
        this.accessPathCount += o.accessPathCount;
        this.accessPathDups += o.accessPathDups;
        this.chunkCount += o.chunkCount;
        this.elementCount += o.elementCount;
        this.bindingSetsOut += o.bindingSetsOut;
        this.bindingSetChunksOut += o.bindingSetChunksOut;
        this.mutationCount.addAndGet(o.mutationCount.get());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JoinStats");
        sb.append("{ orderIndex=" + this.orderIndex);
        sb.append(", partitionId=" + this.partitionId);
        sb.append(", fanIn=" + this.fanIn);
        sb.append(", fanOut=" + this.fanOut);
        sb.append(", partitionIdCount=" + this.partitionCount);
        sb.append(", bindingSetChunksIn=" + this.bindingSetChunksIn);
        sb.append(", bindingSetsIn=" + this.bindingSetsIn);
        sb.append(", accessPathCount=" + this.accessPathCount);
        sb.append(", accessPathDups=" + this.accessPathDups);
        sb.append(", chunkCount=" + this.chunkCount);
        sb.append(", elementCount=" + this.elementCount);
        sb.append(", bindingSetsOut=" + this.bindingSetsOut);
        sb.append(", bindingSetChunksOut=" + this.bindingSetChunksOut);
        sb.append(", mutationCount=" + this.mutationCount);
        sb.append("}");
        return sb.toString();
    }

    public static StringBuilder toString(IRule rule, IRuleState ruleState, JoinStats[] a) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        int[] order = ruleState.getPlan().getOrder();
        StringBuilder sb = new StringBuilder();
        sb.append("startTime, rule, orderIndex, keyOrder, nvars, rangeCount, fanIn, fanOut, partitionCount, bindingSetChunksIn, bindingSetsIn, accessPathCount, accessPathDups, chunkCount, elementCount, bindingSetsOut, bindingSetChunksOut, mutationCount, tailIndex, tailPredicate");
        sb.append("\n");
        int i = 0;
        for (JoinStats s : a) {
            int tailIndex = order[i++];
            String ruleNameStr = "\"" + rule.getName().replace(',', ' ') + "\"";
            sb.append(dateFormat.format(s.startTime).replace(sep, " ") + sep);
            sb.append(ruleNameStr + sep);
            sb.append(Integer.toString(s.orderIndex) + sep);
            sb.append(ruleState.getKeyOrder()[tailIndex].toString().replace(sep, " ") + sep);
            sb.append(ruleState.getNVars()[tailIndex] + sep);
            sb.append(ruleState.getPlan().rangeCount(tailIndex) + sep);
            sb.append(Integer.toString(s.fanIn) + sep);
            sb.append(Integer.toString(s.fanOut) + sep);
            sb.append(Integer.toString(s.partitionCount) + sep);
            sb.append(Long.toString(s.bindingSetChunksIn) + sep);
            sb.append(Long.toString(s.bindingSetsIn) + sep);
            sb.append(Long.toString(s.accessPathCount) + sep);
            sb.append(Long.toString(s.accessPathDups) + sep);
            sb.append(Long.toString(s.chunkCount) + sep);
            sb.append(Long.toString(s.elementCount) + sep);
            sb.append(Long.toString(s.bindingSetsOut) + sep);
            sb.append(Long.toString(s.bindingSetChunksOut) + sep);
            sb.append(Long.toString(s.mutationCount.get()) + sep);
            sb.append(Integer.toString(tailIndex) + sep);
            sb.append(rule.getTail(tailIndex).toString().replace(sep, " ") + "\n");
        }
        return sb;
    }
}

