/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.joinGraph.IEvaluationPlan;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStarJoin;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IRuleState;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RuleState
implements IRuleState {
    protected static final transient Logger log = Logger.getLogger(RuleState.class);
    private final IRule rule;
    private final IEvaluationPlan plan;
    private final int[] nvars;
    private final IKeyOrder[] keyOrder;
    protected final IVariable[][] requiredVars;

    @Override
    public IRule getRule() {
        return this.rule;
    }

    @Override
    public IEvaluationPlan getPlan() {
        return this.plan;
    }

    @Override
    public int[] getNVars() {
        return this.nvars;
    }

    @Override
    public IKeyOrder[] getKeyOrder() {
        return this.keyOrder;
    }

    @Override
    public IVariable[][] getRequiredVars() {
        return this.requiredVars;
    }

    protected RuleState(IRule rule) {
        this.rule = rule;
        this.plan = null;
        this.nvars = null;
        this.keyOrder = null;
        this.requiredVars = null;
    }

    public RuleState(IRule rule, IJoinNexus joinNexus) {
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        if (joinNexus == null) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
        this.plan = joinNexus.getPlanFactory().newPlan(joinNexus, rule);
        this.nvars = new int[rule.getTailCount()];
        this.keyOrder = this.computeKeyOrderForEachTail(rule, joinNexus, this.plan.getOrder(), this.nvars);
        this.requiredVars = RuleState.computeRequiredVarsForEachTail(rule, this.plan.getOrder());
        if (log.isInfoEnabled()) {
            Object[] s = new String[this.requiredVars.length];
            for (int i = 0; i < this.requiredVars.length; ++i) {
                s[i] = Arrays.toString(this.requiredVars[i]);
            }
            log.info((Object)("\nrule=" + rule + "\nplan=" + this.plan + "\nkeyOrder=" + Arrays.toString(this.keyOrder) + "\nrequiredVars=" + Arrays.toString(s)));
        }
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(IBindingSet bindingSet) {
        Object[] s = new String[this.requiredVars.length];
        for (int i = 0; i < this.requiredVars.length; ++i) {
            s[i] = Arrays.toString(this.requiredVars[i]);
        }
        return this.rule.toString(bindingSet) + ", order=" + Arrays.toString(this.plan.getOrder()) + ", keyOrder=" + Arrays.toString(this.keyOrder) + ", nvars=" + Arrays.toString(this.nvars) + ", requiredVars=" + Arrays.toString(s);
    }

    protected IKeyOrder[] computeKeyOrderForEachTail(IRule rule, IJoinNexus joinNexus, int[] order, int[] nvars) {
        if (order == null) {
            throw new IllegalArgumentException();
        }
        if (order.length != rule.getTailCount()) {
            throw new IllegalArgumentException();
        }
        int tailCount = rule.getTailCount();
        Object[] a = new IKeyOrder[tailCount];
        IBindingSet bindingSet = joinNexus.newBindingSet(rule);
        for (int orderIndex = 0; orderIndex < tailCount; ++orderIndex) {
            int tailIndex = order[orderIndex];
            IPredicate pred = rule.getTail(tailIndex);
            IRelation rel = joinNexus.getTailRelationView(pred);
            IPredicate asBound = pred.asBound(bindingSet);
            IKeyOrder keyOrder = joinNexus.getTailAccessPath(rel, asBound).getKeyOrder();
            if (log.isDebugEnabled()) {
                log.debug((Object)("keyOrder=" + keyOrder + ", orderIndex=" + orderIndex + ", tailIndex=" + orderIndex + ", pred=" + pred + ", bindingSet=" + bindingSet + ", rule=" + rule));
            }
            a[tailIndex] = keyOrder;
            nvars[tailIndex] = keyOrder == null ? asBound.getVariableCount() : asBound.getVariableCount(keyOrder);
            int arity = pred.arity();
            for (int j = 0; j < arity; ++j) {
                IVariableOrConstant t = pred.get(j);
                if (!t.isVar()) continue;
                Var var = (Var)t;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Propagating binding: pred=" + pred + ", var=" + var + ", bindingSet=" + bindingSet));
                }
                bindingSet.set((IVariable)var, joinNexus.fakeBinding(pred, var));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("keyOrder[]=" + Arrays.toString(a) + ", nvars=" + Arrays.toString(nvars) + ", rule=" + rule));
        }
        return a;
    }

    public static IVariable[][] computeRequiredVarsForEachTail(IRule rule, int[] order) {
        if (order == null) {
            throw new IllegalArgumentException();
        }
        if (order.length != rule.getTailCount()) {
            throw new IllegalArgumentException();
        }
        int tailCount = rule.getTailCount();
        IVariable[][] a = new IVariable[tailCount][];
        HashSet constraintVars = new HashSet();
        if (rule.getConstraintCount() > 0) {
            Iterator<IConstraint> constraints = rule.getConstraints();
            while (constraints.hasNext()) {
                IConstraint c = constraints.next();
                Iterator<IVariable<?>> vars = BOpUtility.getSpannedVariables(c);
                while (vars.hasNext()) {
                    constraintVars.add(vars.next());
                }
            }
        }
        for (int orderIndex = tailCount - 1; orderIndex >= 0; --orderIndex) {
            HashSet<Object> required = new HashSet<Object>();
            if (orderIndex == tailCount - 1) {
                Iterator<IVariable> it = rule.getRequiredVariables();
                while (it.hasNext()) {
                    required.add(it.next());
                }
            } else {
                IVariable[] nextRequired;
                IVariable v;
                int nextTailIndex = order[orderIndex + 1];
                IPredicate nextPred = rule.getTail(nextTailIndex);
                int arity = nextPred.arity();
                for (int j = 0; j < arity; ++j) {
                    IVariableOrConstant t = nextPred.get(j);
                    if (!t.isVar()) continue;
                    v = (IVariable)t;
                    required.add(v);
                }
                if (nextPred instanceof IStarJoin) {
                    IStarJoin starJoin = (IStarJoin)nextPred;
                    Iterator<IVariable> it = starJoin.getConstraintVariables();
                    while (it.hasNext()) {
                        v = it.next();
                        required.add(v);
                    }
                }
                required.addAll(constraintVars);
                for (IVariable v2 : nextRequired = a[nextTailIndex]) {
                    required.add(v2);
                }
            }
            int tailIndex = order[orderIndex];
            a[tailIndex] = required.toArray(new IVariable[required.size()]);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("requiredVars=" + Arrays.toString(a[tailIndex]) + ", orderIndex=" + orderIndex + ", tailIndex=" + orderIndex + ", pred=" + rule.getTail(tailIndex) + ", rule=" + rule));
        }
        if (log.isDebugEnabled()) {
            Object[] s = new String[a.length];
            for (int i = 0; i < a.length; ++i) {
                s[i] = Arrays.toString(a[i]);
            }
            log.debug((Object)("requiredVars[]=" + Arrays.toString(s) + ", rule=" + rule));
        }
        return a;
    }
}

