/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.Var;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BloomFilterFactory;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.filter.TupleFilter;
import com.bigdata.btree.isolation.IConflictResolver;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.btree.proc.LongAggregator;
import com.bigdata.btree.raba.codec.EmptyRabaValueCoder;
import com.bigdata.btree.raba.codec.FixedLengthValueRabaCoder;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IResourceLock;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.inf.Justification;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.lexicon.ITermIVFilter;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.sparql.ast.QuadsOperationInTriplesModeException;
import com.bigdata.rdf.sparql.ast.service.history.HistoryIndexTupleSerializer;
import com.bigdata.rdf.spo.DistinctMultiTermAdvancer;
import com.bigdata.rdf.spo.DistinctSPOIterator;
import com.bigdata.rdf.spo.DistinctTermAdvancer;
import com.bigdata.rdf.spo.FastRDFValueCoder2;
import com.bigdata.rdf.spo.HistorySPOFilter;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.JustIndexWriteProc;
import com.bigdata.rdf.spo.JustificationRemover;
import com.bigdata.rdf.spo.JustificationTupleSerializer;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOAccessPath;
import com.bigdata.rdf.spo.SPOIndexRemover;
import com.bigdata.rdf.spo.SPOIndexWriter;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.rdf.spo.XXXCShardSplitHandler;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.AbstractRelation;
import com.bigdata.relation.accesspath.ArrayAccessPath;
import com.bigdata.relation.accesspath.ElementFilter;
import com.bigdata.relation.accesspath.EmptyAccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.EmptyChunkedIterator;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class SPORelation
extends AbstractRelation<ISPO> {
    protected static final transient Logger log = Logger.getLogger(SPORelation.class);
    private final Set<String> indexNames;
    private final List<SPOKeyOrder> keyOrders;
    private final int keyArity;
    private final IIndex[] indices;
    private volatile IIndex just;
    public static final String NAME_SPO_RELATION = "spo";
    private static final transient String NAME_JUST = "JUST";
    public final boolean justify = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.JUSTIFY, "true"));
    public final boolean oneAccessPath = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.ONE_ACCESS_PATH, "false"));
    protected final boolean bloomFilter;
    private final boolean historyService;
    private final boolean history;
    private final boolean statementIdentifiers = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "false"));
    public static final transient String NAME_HISTORY = "HIST";

    public int getKeyArity() {
        return this.keyArity;
    }

    public boolean getStatementIdentifiers() {
        return this.statementIdentifiers;
    }

    public SPORelation(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        this(null, indexManager, namespace, timestamp, properties);
    }

    public SPORelation(AbstractTripleStore container, IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(container, indexManager, namespace, timestamp, properties);
        this.historyService = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.HISTORY_SERVICE, "false"));
        int n = this.keyArity = Boolean.valueOf(this.getProperty(AbstractTripleStore.Options.QUADS, "false")) != false ? 4 : 3;
        if (this.statementIdentifiers && this.keyArity == 4) {
            throw new UnsupportedOperationException(AbstractTripleStore.Options.QUADS + " does not support the provenance mode (" + AbstractTripleStore.Options.STATEMENT_IDENTIFIERS + ")");
        }
        this.bloomFilter = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.BLOOM_FILTER, "true"));
        String historyClass = this.getProperty(AbstractTripleStore.Options.RDR_HISTORY_CLASS, null);
        this.history = historyClass != null && historyClass.length() > 0;
        HashSet<String> set = new HashSet<String>();
        if (this.keyArity == 3) {
            this.indices = new IIndex[3];
            if (this.oneAccessPath) {
                set.add(this.getFQN(SPOKeyOrder.SPO));
                this.keyOrders = Collections.unmodifiableList(Arrays.asList(SPOKeyOrder.SPO));
            } else {
                set.add(this.getFQN(SPOKeyOrder.SPO));
                set.add(this.getFQN(SPOKeyOrder.POS));
                set.add(this.getFQN(SPOKeyOrder.OSP));
                this.keyOrders = Collections.unmodifiableList(Arrays.asList(SPOKeyOrder.SPO, SPOKeyOrder.POS, SPOKeyOrder.OSP));
            }
        } else {
            this.indices = new IIndex[9];
            if (this.oneAccessPath) {
                set.add(this.getFQN(SPOKeyOrder.SPOC));
                this.keyOrders = Collections.unmodifiableList(Arrays.asList(SPOKeyOrder.SPOC));
            } else {
                ArrayList<SPOKeyOrder> tmp = new ArrayList<SPOKeyOrder>(6);
                for (int i = 3; i <= 8; ++i) {
                    set.add(this.getFQN(SPOKeyOrder.valueOf(i)));
                    tmp.add(SPOKeyOrder.valueOf(i));
                }
                this.keyOrders = Collections.unmodifiableList(tmp);
            }
        }
        if (this.justify) {
            set.add(this.getNamespace() + "." + NAME_JUST);
        }
        this.indexNames = Collections.unmodifiableSet(set);
    }

    @Override
    public AbstractTripleStore getContainer() {
        return (AbstractTripleStore)super.getContainer();
    }

    public boolean exists() {
        for (String name : this.getIndexNames()) {
            if (this.getIndex(name) != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() {
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            int i;
            boolean triples;
            super.create();
            IIndexManager indexManager = this.getIndexManager();
            boolean bl = triples = this.keyArity == 3;
            if (triples) {
                if (this.oneAccessPath) {
                    indexManager.registerIndex(this.getStatementIndexMetadata(SPOKeyOrder.SPO));
                } else {
                    for (i = 0; i <= 2; ++i) {
                        indexManager.registerIndex(this.getStatementIndexMetadata(SPOKeyOrder.valueOf(i)));
                    }
                }
            } else if (this.oneAccessPath) {
                indexManager.registerIndex(this.getStatementIndexMetadata(SPOKeyOrder.SPOC));
            } else {
                for (i = 3; i <= 8; ++i) {
                    indexManager.registerIndex(this.getStatementIndexMetadata(SPOKeyOrder.valueOf(i)));
                }
            }
            if (this.justify) {
                String fqn = this.getNamespace() + "." + NAME_JUST;
                indexManager.registerIndex(this.getJustIndexMetadata(fqn));
            }
            if (this.historyService) {
                SPOKeyOrder keyOrder = triples ? SPOKeyOrder.POS : SPOKeyOrder.PCSO;
                indexManager.registerIndex(this.getHistoryIndexMetadata(keyOrder));
            }
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            IIndexManager indexManager = this.getIndexManager();
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = null;
            }
            for (String name : this.getIndexNames()) {
                indexManager.dropIndex(name);
            }
            this.just = null;
            super.destroy();
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IIndex getIndex(IKeyOrder<? extends ISPO> keyOrder) {
        int n = ((SPOKeyOrder)keyOrder).index();
        IIndex ndx = this.indices[n];
        if (ndx != null) return ndx;
        IIndex[] iIndexArray = this.indices;
        synchronized (this.indices) {
            ndx = this.indices[n] = super.getIndex(keyOrder);
            if (this.indices[n] != null) return ndx;
            throw new IllegalArgumentException(keyOrder.toString());
        }
    }

    public final SPOKeyOrder getPrimaryKeyOrder() {
        return this.keyArity == 3 ? SPOKeyOrder.SPO : SPOKeyOrder.SPOC;
    }

    public final IIndex getPrimaryIndex() {
        return this.getIndex(this.getPrimaryKeyOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IIndex getJustificationIndex() {
        if (!this.justify) {
            return null;
        }
        if (this.just == null) {
            SPORelation sPORelation = this;
            synchronized (sPORelation) {
                this.just = super.getIndex(this.getNamespace() + "." + NAME_JUST);
                if (this.just == null) {
                    throw new IllegalStateException();
                }
            }
        }
        return this.just;
    }

    public ICloseableIterator<ISPO> distinctSPOIterator(ICloseableIterator<ISPO> src) {
        if (!src.hasNext()) {
            return new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        return new DistinctSPOIterator(this, src);
    }

    public BTree getSPOOnlyBTree(boolean bloomFilter) {
        TemporaryStore tempStore = this.getIndexManager().getTempStore();
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        IRabaCoder leafKeySer = DefaultTupleSerializer.getDefaultLeafKeysCoder();
        EmptyRabaValueCoder leafValSer = EmptyRabaValueCoder.INSTANCE;
        metadata.setTupleSerializer(new SPOTupleSerializer(SPOKeyOrder.SPO, false, leafKeySer, leafValSer));
        if (bloomFilter) {
            metadata.setBloomFilterFactory(BloomFilterFactory.DEFAULT);
        }
        BTree ndx = BTree.create(tempStore, metadata);
        return ndx;
    }

    protected IndexMetadata getStatementIndexMetadata(SPOKeyOrder keyOrder) {
        IndexMetadata metadata = this.newIndexMetadata(this.getFQN(keyOrder));
        IRabaCoder leafKeySer = DefaultTupleSerializer.getDefaultLeafKeysCoder();
        FastRDFValueCoder2 leafValSer = new FastRDFValueCoder2();
        metadata.setTupleSerializer(new SPOTupleSerializer(keyOrder, this.statementIdentifiers, leafKeySer, leafValSer));
        if (this.getIndexManager() instanceof IBigdataFederation && ((IBigdataFederation)this.getIndexManager()).isScaleOut() && keyOrder.getKeyArity() == 4 && this.getContainer().isConstrainXXXCShards() && keyOrder.getIndexName().endsWith("C")) {
            metadata.setSplitHandler(new XXXCShardSplitHandler());
        }
        if (this.bloomFilter && (keyOrder.equals(SPOKeyOrder.SPO) || keyOrder.equals(SPOKeyOrder.SPOC))) {
            BloomFilterFactory factory = BloomFilterFactory.DEFAULT;
            if (log.isInfoEnabled()) {
                log.info((Object)("Enabling bloom filter for SPO index: " + factory));
            }
            metadata.setBloomFilterFactory(factory);
        }
        if (TimestampUtility.isReadWriteTx(this.getTimestamp())) {
            metadata.setIsolatable(true);
            if (NoAxioms.class.getName().equals(this.getContainer().getProperties().getProperty(AbstractTripleStore.Options.AXIOMS_CLASS, AbstractTripleStore.Options.DEFAULT_AXIOMS_CLASS))) {
                metadata.setConflictResolver(new SPOWriteWriteResolver());
            }
        }
        return metadata;
    }

    protected IndexMetadata getHistoryIndexMetadata(SPOKeyOrder keyOrder) {
        IndexMetadata metadata = this.newIndexMetadata(SPORelation.getFQN(this, NAME_HISTORY));
        IRabaCoder leafKeySer = DefaultTupleSerializer.getDefaultLeafKeysCoder();
        FixedLengthValueRabaCoder leafValSer = new FixedLengthValueRabaCoder(1);
        metadata.setTupleSerializer(new HistoryIndexTupleSerializer(keyOrder, this.statementIdentifiers, leafKeySer, leafValSer));
        if (TimestampUtility.isReadWriteTx(this.getTimestamp())) {
            metadata.setIsolatable(true);
        }
        return metadata;
    }

    protected IndexMetadata getJustIndexMetadata(String name) {
        IndexMetadata metadata = this.newIndexMetadata(name);
        metadata.setTupleSerializer(new JustificationTupleSerializer(this.keyArity));
        return metadata;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    @Override
    public Iterator<IKeyOrder<ISPO>> getKeyOrders() {
        return this.keyOrders.iterator();
    }

    public Iterator<SPOKeyOrder> statementKeyOrderIterator() {
        switch (this.keyArity) {
            case 3: {
                if (this.oneAccessPath) {
                    return SPOKeyOrder.spoOnlyKeyOrderIterator();
                }
                return SPOKeyOrder.tripleStoreKeyOrderIterator();
            }
            case 4: {
                if (this.oneAccessPath) {
                    return SPOKeyOrder.spocOnlyKeyOrderIterator();
                }
                return SPOKeyOrder.quadStoreKeyOrderIterator();
            }
        }
        throw new AssertionError();
    }

    public IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o) {
        if (this.keyArity != 3) {
            throw new UnsupportedOperationException();
        }
        return this.getAccessPath(s, p, o, null, null, null);
    }

    public IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o, IV c) {
        return this.getAccessPath(s, p, o, c, null, null);
    }

    public IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o, IV c, RangeBOp range) {
        return this.getAccessPath(s, p, o, c, null, range);
    }

    public IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o, IV c, IElementFilter<ISPO> filter) {
        return this.getAccessPath(s, p, o, c, filter, null);
    }

    public IAccessPath<ISPO> getAccessPath(IV s, IV p, IV o, IV c, IElementFilter<ISPO> filter, RangeBOp range) {
        IPredicate<ISPO> pred = this.getPredicate(s, p, o, c, filter, range);
        return this.getAccessPath(pred);
    }

    public IPredicate<ISPO> getPredicate(IV s, IV p, IV o, IV c) {
        return this.getPredicate(s, p, o, c, null, null);
    }

    public IPredicate<ISPO> getPredicate(IV s, IV p, IV o, IV c, IElementFilter<ISPO> filter, RangeBOp range) {
        BOp[] bOpArray;
        IVariableOrConstant S = (IVariableOrConstant)(s == null ? Var.var("s") : new Constant<IV>(s));
        IVariableOrConstant P2 = (IVariableOrConstant)(p == null ? Var.var("p") : new Constant<IV>(p));
        IVariableOrConstant O = (IVariableOrConstant)(o == null ? Var.var("o") : new Constant<IV>(o));
        IVariableOrConstant C = null;
        switch (this.keyArity) {
            case 3: {
                if (this.statementIdentifiers) {
                    C = (IVariableOrConstant)(c == null ? Var.var("c") : new Constant<IV>(c));
                    break;
                }
                if (c == null) break;
                throw new RuntimeException(new QuadsOperationInTriplesModeException("Predicate lookup with bound context, but DB is initialized in triples mode. Please do either re-init your database in quads mode or use operations over triples only."));
            }
            case 4: {
                C = (IVariableOrConstant)(c == null ? Var.var("c") : new Constant<IV>(c));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        LinkedHashMap<String, Object> anns = new LinkedHashMap<String, Object>();
        anns.put(IPredicate.Annotations.RELATION_NAME, new String[]{this.getNamespace()});
        if (range != null) {
            anns.put(IPredicate.Annotations.RANGE, range);
        }
        if (this.keyArity == 4 || this.statementIdentifiers) {
            BOp[] bOpArray2 = new BOp[4];
            bOpArray2[0] = S;
            bOpArray2[1] = P2;
            bOpArray2[2] = O;
            bOpArray = bOpArray2;
            bOpArray2[3] = C;
        } else {
            BOp[] bOpArray3 = new BOp[3];
            bOpArray3[0] = S;
            bOpArray3[1] = P2;
            bOpArray = bOpArray3;
            bOpArray3[2] = O;
        }
        Predicate pred = new SPOPredicate(bOpArray, anns);
        if (filter != null) {
            pred = pred.addIndexLocalFilter(ElementFilter.newInstance(filter));
        }
        return pred;
    }

    public SPOKeyOrder getKeyOrder(IPredicate<ISPO> predicate) {
        return SPOKeyOrder.getKeyOrder(predicate, this.keyArity);
    }

    @Override
    public IAccessPath<ISPO> newAccessPath(IIndexManager localIndexManager, IPredicate<ISPO> predicate, IKeyOrder<ISPO> keyOrder) {
        IVariableOrConstant sid;
        if (this.statementIdentifiers && predicate.arity() == 4 && (sid = predicate.get(3)) != null && sid.isConstant() && sid.get() instanceof SidIV) {
            SidIV sidIV = (SidIV)sid.get();
            ISPO spo = sidIV.getInlineValue();
            for (int i = 0; i <= 2; ++i) {
                IVariableOrConstant t = predicate.get(i);
                if (t == null || !t.isConstant()) continue;
                IV iv = (IV)t.get();
                if (spo.get(i).equals(iv)) continue;
                return new EmptyAccessPath<ISPO>(predicate, SPOKeyOrder.SPO);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("materializing an inline SID access path: " + spo));
            }
            return new ArrayAccessPath<ISPO>(new ISPO[]{spo}, predicate, SPOKeyOrder.SPO);
        }
        IPredicate<ISPO> historyFiltered = this.history && (Boolean)predicate.getProperty(SPOPredicate.Annotations.INCLUDE_HISTORY, false) == false ? ((Predicate)predicate).addIndexLocalFilter(ElementFilter.newInstance(HistorySPOFilter.INSTANCE)) : predicate;
        return new SPOAccessPath(this, localIndexManager, historyFiltered, keyOrder).init();
    }

    public IChunkedIterator<IV> distinctTermScan(IKeyOrder<ISPO> keyOrder) {
        return this.distinctTermScan(keyOrder, null);
    }

    public IChunkedIterator<IV> distinctTermScan(IKeyOrder<ISPO> keyOrder, ITermIVFilter filter) {
        return this.distinctTermScan(keyOrder, null, null, filter);
    }

    public IChunkedIterator<IV> distinctTermScan(IKeyOrder<ISPO> keyOrder, byte[] fromKey, byte[] toKey, final ITermIVFilter termIdFilter) {
        DistinctTermAdvancer filter = new DistinctTermAdvancer(this.keyArity);
        if (termIdFilter != null) {
            filter.addFilter(new TupleFilter<SPO>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isValid(ITuple<SPO> tuple) {
                    byte[] key = tuple.getKey();
                    IV iv = IVUtility.decode(key);
                    return termIdFilter.isValid(iv);
                }
            });
        }
        IStriterator itr = new Striterator((Iterator)this.getIndex((IKeyOrder<? extends ISPO>)keyOrder).rangeIterator(fromKey, toKey, 0, 33, filter)).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected IV resolve(Object obj) {
                byte[] key = ((ITuple)obj).getKey();
                return IVUtility.decode(key);
            }
        });
        return new ChunkedWrappedIterator<IV>((Iterator<IV>)itr, 100, IV.class);
    }

    public IChunkedIterator<IV> distinctMultiTermScan(IKeyOrder<ISPO> keyOrder, IV[] knownTerms) {
        return this.distinctMultiTermScan(keyOrder, knownTerms, null);
    }

    public IChunkedIterator<IV> distinctMultiTermScan(IKeyOrder<ISPO> keyOrder, final IV[] knownTerms, final ITermIVFilter termIdFilter) {
        int nterms = knownTerms.length;
        IKeyBuilder keyBuilder = KeyBuilder.newInstance();
        for (int i = 0; i < knownTerms.length; ++i) {
            knownTerms[i].encode(keyBuilder);
        }
        byte[] fromKey = knownTerms.length == 0 ? null : keyBuilder.getKey();
        byte[] toKey = fromKey == null ? null : SuccessorUtil.successor((byte[])fromKey.clone());
        DistinctMultiTermAdvancer filter = new DistinctMultiTermAdvancer(this.getKeyArity(), nterms);
        if (termIdFilter != null) {
            filter.addFilter(new TupleFilter<SPO>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isValid(ITuple<SPO> tuple) {
                    byte[] key = tuple.getKey();
                    int pos = knownTerms.length;
                    IV iv = IVUtility.decode(key, pos + 1)[pos];
                    return termIdFilter.isValid(iv);
                }
            });
        }
        IStriterator itr = new Striterator((Iterator)this.getIndex((IKeyOrder<? extends ISPO>)keyOrder).rangeIterator(fromKey, toKey, 0, 33, filter)).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected IV resolve(Object obj) {
                byte[] key = ((ITuple)obj).getKey();
                int pos = knownTerms.length;
                return IVUtility.decode(key, pos + 1)[pos];
            }
        });
        return new ChunkedWrappedIterator<IV>((Iterator<IV>)itr, 100, IV.class);
    }

    @Override
    public SPO newElement(List<BOp> a, IBindingSet bindingSet) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        IV s = (IV)((IVariableOrConstant)a.get(0)).get(bindingSet);
        IV p = (IV)((IVariableOrConstant)a.get(1)).get(bindingSet);
        IV o = (IV)((IVariableOrConstant)a.get(2)).get(bindingSet);
        SPO spo = new SPO(s, p, o, StatementEnum.Inferred);
        if (log.isDebugEnabled()) {
            log.debug((Object)spo.toString());
        }
        return spo;
    }

    @Override
    public Class<ISPO> getElementClass() {
        return ISPO.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(IChunkedOrderedIterator<ISPO> itr) {
        try {
            long n = 0L;
            while (itr.hasNext()) {
                ISPO[] a = (ISPO[])itr.nextChunk();
                n += this.insert(a, a.length, null);
            }
            long l = n;
            return l;
        }
        finally {
            itr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(IChunkedOrderedIterator<ISPO> itr) {
        try {
            long n = 0L;
            while (itr.hasNext()) {
                ISPO[] a = (ISPO[])itr.nextChunk();
                n += this.delete(a, a.length);
            }
            long l = n;
            return l;
        }
        finally {
            itr.close();
        }
    }

    public long insert(ISPO[] a, int numStmts, IElementFilter<ISPO> filter) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (numStmts > a.length) {
            throw new IllegalArgumentException();
        }
        if (numStmts == 0) {
            return 0L;
        }
        long begin = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("indexManager=" + this.getIndexManager()));
        }
        AtomicLong sortTime = new AtomicLong(0L);
        AtomicLong insertTime = new AtomicLong(0L);
        AtomicLong mutationCount = new AtomicLong(0L);
        ArrayList<SPOIndexWriter> tasks = new ArrayList<SPOIndexWriter>(3);
        boolean reportMutation = true;
        if (this.keyArity == 3) {
            tasks.add(new SPOIndexWriter(this, a, numStmts, false, SPOKeyOrder.SPO, SPOKeyOrder.SPO.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, true));
            if (!this.oneAccessPath) {
                tasks.add(new SPOIndexWriter(this, a, numStmts, true, SPOKeyOrder.POS, SPOKeyOrder.POS.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, false));
                tasks.add(new SPOIndexWriter(this, a, numStmts, true, SPOKeyOrder.OSP, SPOKeyOrder.OSP.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, false));
            }
        } else {
            tasks.add(new SPOIndexWriter(this, a, numStmts, false, SPOKeyOrder.SPOC, SPOKeyOrder.SPOC.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, true));
            if (!this.oneAccessPath) {
                tasks.add(new SPOIndexWriter(this, a, numStmts, true, SPOKeyOrder.POCS, SPOKeyOrder.POCS.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, false));
                tasks.add(new SPOIndexWriter(this, a, numStmts, true, SPOKeyOrder.OCSP, SPOKeyOrder.OCSP.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, false));
                tasks.add(new SPOIndexWriter(this, a, numStmts, true, SPOKeyOrder.CSPO, SPOKeyOrder.CSPO.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, false));
                tasks.add(new SPOIndexWriter(this, a, numStmts, true, SPOKeyOrder.PCSO, SPOKeyOrder.PCSO.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, false));
                tasks.add(new SPOIndexWriter(this, a, numStmts, true, SPOKeyOrder.SOPC, SPOKeyOrder.SOPC.isPrimaryIndex(), filter, sortTime, insertTime, mutationCount, false));
            }
        }
        try {
            List futures = this.getExecutorService().invokeAll(tasks);
            for (int i = 0; i < tasks.size(); ++i) {
                this.logFuture(futures.get(i));
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled() && numStmts > 1000) {
            log.info((Object)("Wrote " + numStmts + " statements (mutationCount=" + mutationCount + ") in " + elapsed + "ms" + "; sort=" + sortTime + "ms" + ", keyGen+insert=" + insertTime + "ms"));
        }
        return mutationCount.get();
    }

    private <T> T logFuture(Future<T> f) throws ExecutionException, InterruptedException {
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            log.warn((Object)e, (Throwable)e);
            throw e;
        }
        catch (ExecutionException e) {
            log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    public long delete(ISPO[] stmts, int numStmts) {
        if (stmts == null) {
            throw new IllegalArgumentException();
        }
        if (numStmts < 0 || numStmts > stmts.length) {
            throw new IllegalArgumentException();
        }
        if (numStmts == 0) {
            return 0L;
        }
        long begin = System.currentTimeMillis();
        if (this.history) {
            ISPO[] a = new ISPO[numStmts];
            for (int i = 0; i < numStmts; ++i) {
                a[i] = new SPO(stmts[i].s(), stmts[i].p(), stmts[i].o(), StatementEnum.History);
            }
            long nmodified = this.insert(a, numStmts, null);
            for (int i = 0; i < numStmts; ++i) {
                stmts[i].setModified(a[i].getModified());
            }
            return nmodified;
        }
        AtomicLong sortTime = new AtomicLong(0L);
        AtomicLong writeTime = new AtomicLong(0L);
        AtomicLong mutationCount = new AtomicLong(0L);
        ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>(3);
        boolean reportMutation = true;
        if (this.keyArity == 3) {
            tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.SPO, SPOKeyOrder.SPO.isPrimaryIndex(), false, sortTime, writeTime, mutationCount, true));
            if (!this.oneAccessPath) {
                tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.POS, SPOKeyOrder.POS.isPrimaryIndex(), true, sortTime, writeTime, mutationCount, false));
                tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.OSP, SPOKeyOrder.OSP.isPrimaryIndex(), true, sortTime, writeTime, mutationCount, false));
            }
        } else {
            tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.SPOC, SPOKeyOrder.SPOC.isPrimaryIndex(), false, sortTime, writeTime, mutationCount, true));
            if (!this.oneAccessPath) {
                tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.POCS, SPOKeyOrder.POCS.isPrimaryIndex(), true, sortTime, writeTime, mutationCount, false));
                tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.OCSP, SPOKeyOrder.OCSP.isPrimaryIndex(), true, sortTime, writeTime, mutationCount, false));
                tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.CSPO, SPOKeyOrder.CSPO.isPrimaryIndex(), true, sortTime, writeTime, mutationCount, false));
                tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.PCSO, SPOKeyOrder.PCSO.isPrimaryIndex(), true, sortTime, writeTime, mutationCount, false));
                tasks.add(new SPOIndexRemover(this, stmts, numStmts, SPOKeyOrder.SOPC, SPOKeyOrder.SOPC.isPrimaryIndex(), true, sortTime, writeTime, mutationCount, false));
            }
        }
        if (this.justify) {
            tasks.add(new JustificationRemover(this, stmts, numStmts, true, sortTime, writeTime));
        }
        try {
            List futures = this.getExecutorService().invokeAll(tasks);
            for (int i = 0; i < tasks.size(); ++i) {
                futures.get(i).get();
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled() && numStmts > 1000) {
            log.info((Object)("Removed " + numStmts + " in " + elapsed + "ms; sort=" + sortTime + "ms, keyGen+delete=" + writeTime + "ms"));
        }
        return mutationCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addJustifications(IChunkedIterator<Justification> itr) {
        try {
            if (!itr.hasNext()) {
                long l = 0L;
                return l;
            }
            long begin = System.currentTimeMillis();
            long nwritten = 0L;
            IIndex ndx = this.getJustificationIndex();
            JustificationTupleSerializer tupleSer = (JustificationTupleSerializer)ndx.getIndexMetadata().getTupleSerializer();
            while (itr.hasNext()) {
                Object[] a = itr.nextChunk();
                int n = a.length;
                Arrays.sort(a);
                byte[][] keys = new byte[n][];
                for (int i = 0; i < n; ++i) {
                    keys[i] = tupleSer.serializeKey(a[i]);
                }
                LongAggregator aggregator = new LongAggregator();
                ndx.submit(0, n, keys, null, JustIndexWriteProc.WriteJustificationsProcConstructor.INSTANCE, aggregator);
                nwritten += aggregator.getResult().longValue();
            }
            long elapsed = System.currentTimeMillis() - begin;
            if (log.isInfoEnabled()) {
                log.info((Object)("Wrote " + nwritten + " justifications in " + elapsed + " ms"));
            }
            long l = nwritten;
            return l;
        }
        finally {
            itr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder dump(IKeyOrder<ISPO> keyOrder) {
        BOp[] bOpArray;
        StringBuilder sb = new StringBuilder();
        if (this.keyArity == 4) {
            BOp[] bOpArray2 = new BOp[4];
            bOpArray2[0] = Var.var("s");
            bOpArray2[1] = Var.var("p");
            bOpArray2[2] = Var.var("o");
            bOpArray = bOpArray2;
            bOpArray2[3] = Var.var("c");
        } else {
            BOp[] bOpArray3 = new BOp[3];
            bOpArray3[0] = Var.var("s");
            bOpArray3[1] = Var.var("p");
            bOpArray = bOpArray3;
            bOpArray3[2] = Var.var("o");
        }
        SPOPredicate pred = new SPOPredicate(bOpArray, NV.asMap(new NV(IPredicate.Annotations.RELATION_NAME, new String[]{this.getNamespace()})));
        try (IChunkedOrderedIterator<ISPO> itr = this.getAccessPath(keyOrder, pred).iterator();){
            while (itr.hasNext()) {
                sb.append(itr.next());
                sb.append("\n");
            }
        }
        return sb;
    }

    public boolean indicesHaveDeleteMarkers() {
        return this.getPrimaryIndex().getIndexMetadata().getDeleteMarkers();
    }

    private static class SPOWriteWriteResolver
    implements IConflictResolver {
        private static final long serialVersionUID = -1591732801502917983L;

        @Override
        public boolean resolveConflict(IIndex writeSet, ITuple txTuple, ITuple currentTuple) throws Exception {
            return !txTuple.isDeletedVersion() && !currentTuple.isDeletedVersion();
        }
    }
}

