/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GroupMemberValueExpressionNodeBase;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.SolutionSetStatserator;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;

public class ASTStaticBindingsOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        StaticBindingInfo staticBindingInfo = new StaticBindingInfo(bindingSets);
        if (bindingSets == null || !(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        VariableUsageInfo varUsageInfo = new VariableUsageInfo();
        HashSet<InlineTasks> inlineTasks = new HashSet<InlineTasks>();
        VariableUsageInfo childVarUsageInfo = new VariableUsageInfo();
        childVarUsageInfo.extractVarSPUsageInfoChildrenOrSelf(queryRoot.getWhereClause());
        ISolutionSetStats stats = SolutionSetStatserator.get(bindingSets);
        Map<IVariable<?>, IConstant<?>> staticVars = SolutionSetStatserator.get(bindingSets).getConstants();
        for (IVariable<?> var : staticVars.keySet()) {
            if (!childVarUsageInfo.varUsed(var)) continue;
            IConstant<?> value = staticVars.get(var);
            inlineTasks.add(new InlineTasks(var, value, childVarUsageInfo.getVarUsages(var)));
        }
        IBindingSet[] bindingSetsOut = this.optimize(sa, queryRoot, staticBindingInfo, varUsageInfo, inlineTasks, queryRoot.getBindingsClause());
        context.setSolutionSetStats(SolutionSetStatserator.get(bindingSetsOut));
        return new QueryNodeWithBindingSet(queryRoot, bindingSetsOut);
    }

    private IBindingSet[] optimize(StaticAnalysis sa, QueryBase queryRoot, StaticBindingInfo staticBindingInfo, VariableUsageInfo ancestorVarUsageInfo, Set<InlineTasks> inlineTasks, BindingsClause bindingsClause) {
        if (bindingsClause != null) {
            List<IBindingSet> bs = bindingsClause.getBindingSets();
            IBindingSet[] bsList = bs.toArray(new IBindingSet[bs.size()]);
            staticBindingInfo.addProduced(bs);
            queryRoot.setBindingsClause(null);
            VariableUsageInfo childVarUsageInfo = new VariableUsageInfo();
            childVarUsageInfo.extractVarSPUsageInfoChildrenOrSelf(queryRoot.getWhereClause());
            Map<IVariable<?>, IConstant<?>> staticVars = SolutionSetStatserator.get(bsList).getConstants();
            for (IVariable<?> var : staticVars.keySet()) {
                if (!childVarUsageInfo.varUsed(var)) continue;
                IConstant<?> value = staticVars.get(var);
                inlineTasks.add(new InlineTasks(var, value, childVarUsageInfo.getVarUsages(var)));
            }
        }
        this.optimize(sa, queryRoot.getWhereClause(), staticBindingInfo, ancestorVarUsageInfo, inlineTasks);
        for (InlineTasks inlineTask : inlineTasks) {
            inlineTask.apply();
        }
        IBindingSet[] bindingSetsOut = staticBindingInfo.joinProduced();
        return bindingSetsOut;
    }

    private IBindingSet[] optimize(StaticAnalysis sa, SubqueryRoot subqueryRoot, StaticBindingInfo staticBindingInfo, VariableUsageInfo ancestorVarUsageInfo, Set<InlineTasks> inlineTasks) {
        IBindingSet[] staticBindings = this.optimize(sa, subqueryRoot, staticBindingInfo, ancestorVarUsageInfo, inlineTasks, subqueryRoot.getBindingsClause());
        LinkedHashSet bcVars = new LinkedHashSet();
        bcVars.addAll(SolutionSetStatserator.get(staticBindings).getUsedVars());
        List<IBindingSet> bcBindings = Arrays.asList(staticBindings);
        if (!bcVars.isEmpty()) {
            BindingsClause bc = new BindingsClause(bcVars, bcBindings);
            subqueryRoot.setBindingsClause(bc);
        }
        return staticBindings;
    }

    private void optimize(StaticAnalysis sa, GroupNodeBase<?> group, StaticBindingInfo staticBindingInfo, VariableUsageInfo ancestorVarUsageInfo, Set<InlineTasks> inlineTasks) {
        if (group == null) {
            return;
        }
        if (group instanceof JoinGroupNode && (((JoinGroupNode)group).isOptional() || ((JoinGroupNode)group).isMinus())) {
            return;
        }
        if (group instanceof UnionNode) {
            return;
        }
        VariableUsageInfo selfVarUsageInfo = new VariableUsageInfo();
        selfVarUsageInfo.extractVarUsageInfoSelf(group);
        VariableUsageInfo ancOrSelfVarUsageInfo = VariableUsageInfo.merge(ancestorVarUsageInfo, selfVarUsageInfo);
        VariableUsageInfo childVarUsageInfo = new VariableUsageInfo();
        childVarUsageInfo.extractVarSPUsageInfoChildren(group);
        ArrayList<IGroupMemberNode> toRemove = new ArrayList<IGroupMemberNode>();
        HashSet optOrMinusVars = new HashSet();
        for (IGroupMemberNode child : group) {
            if (child instanceof AssignmentNode) {
                AssignmentNode an = (AssignmentNode)child;
                IValueExpression<? extends IV> ve = an.getValueExpression();
                if (ve instanceof IConstant && an.args().get(1) instanceof ConstantNode) {
                    VariableUsageInfo usageInfo;
                    IVariable<IV> boundVar = an.getVar();
                    if (!ancOrSelfVarUsageInfo.varUsedInFilterOrAssignment(boundVar) && !optOrMinusVars.contains(boundVar)) {
                        ListBindingSet bs = new ListBindingSet();
                        bs.set(boundVar, (IConstant)an.getValueExpression());
                        staticBindingInfo.addProduced(bs);
                        toRemove.add(child);
                    }
                    if ((usageInfo = VariableUsageInfo.merge(ancOrSelfVarUsageInfo, childVarUsageInfo)).varUsed(boundVar)) {
                        inlineTasks.add(new InlineTasks(boundVar, (IConstant<IV>)((IConstant)an.getValueExpression()), usageInfo.getVarUsages(boundVar)));
                    }
                }
            } else if (child instanceof BindingsClause) {
                VariableUsageInfo usageInfo;
                BindingsClause bc = (BindingsClause)child;
                List<IBindingSet> bss = bc.getBindingSets();
                Set<IVariable<?>> bssVars = sa.getVarsInBindingSet(bss);
                boolean someVarUsedInFilterOrPrevOptOrMinus = false;
                for (IVariable<?> bssVar : bssVars) {
                    someVarUsedInFilterOrPrevOptOrMinus |= ancOrSelfVarUsageInfo.varUsedInFilterOrAssignment(bssVar) || optOrMinusVars.contains(bssVar);
                }
                if (!someVarUsedInFilterOrPrevOptOrMinus) {
                    staticBindingInfo.addProduced(bc.getBindingSets());
                    toRemove.add(child);
                    usageInfo = VariableUsageInfo.merge(ancOrSelfVarUsageInfo, childVarUsageInfo);
                }
                usageInfo = VariableUsageInfo.merge(ancOrSelfVarUsageInfo, childVarUsageInfo);
                IBindingSet[] bs = bss.toArray(new IBindingSet[bss.size()]);
                Map<IVariable<?>, IConstant<?>> constantVars = SolutionSetStatserator.get(bs).getConstants();
                for (IVariable<?> iVariable : constantVars.keySet()) {
                    if (!usageInfo.varUsed(iVariable)) continue;
                    IConstant<?> constantVal = constantVars.get(iVariable);
                    inlineTasks.add(new InlineTasks(iVariable, constantVal, usageInfo.getVarUsages(iVariable)));
                }
            } else if (child instanceof FilterNode) {
                BOp varNodeCandidate;
                int arity;
                FilterNode filter = (FilterNode)child;
                IValueExpressionNode vexpr = filter.getValueExpressionNode();
                if (!(vexpr instanceof FunctionNode)) {
                    return;
                }
                FunctionNode functionNode = (FunctionNode)vexpr;
                URI functionURI = functionNode.getFunctionURI();
                if (functionURI.equals((Object)FunctionRegistry.SAME_TERM) || functionURI.equals((Object)FunctionRegistry.EQ)) {
                    IV constant;
                    IValueExpressionNode left = (IValueExpressionNode)functionNode.get(0);
                    IValueExpressionNode right = (IValueExpressionNode)functionNode.get(1);
                    ListBindingSet bs = new ListBindingSet();
                    if (left instanceof VarNode && right instanceof ConstantNode) {
                        constant = (IV)((ConstantNode)right).getValueExpression().get();
                        if (functionURI.equals((Object)FunctionRegistry.EQ) && constant.isLiteral()) {
                            return;
                        }
                        bs.set((IVariable)left.getValueExpression(), (IConstant)right.getValueExpression());
                    } else if (left instanceof ConstantNode && right instanceof VarNode) {
                        constant = (IV)((ConstantNode)left).getValueExpression().get();
                        if (functionURI.equals((Object)FunctionRegistry.EQ) && constant.isLiteral()) {
                            return;
                        }
                        bs.set((IVariable)right.getValueExpression(), (IConstant)left.getValueExpression());
                    }
                    if (!bs.isEmpty() && bs.size() == 1) {
                        Map.Entry entry = (Map.Entry)bs.iterator().next();
                        IVariable iVariable = (IVariable)entry.getKey();
                        IConstant val = (IConstant)entry.getValue();
                        VariableUsageInfo usageInfo = VariableUsageInfo.merge(ancOrSelfVarUsageInfo, childVarUsageInfo);
                        if (usageInfo.varUsed(iVariable)) {
                            inlineTasks.add(new InlineTasks(iVariable, (IConstant<IV>)val, usageInfo.getVarUsages(iVariable)));
                        }
                    }
                } else if (functionURI.equals((Object)FunctionRegistry.IN) && (arity = functionNode.arity()) == 2 && (varNodeCandidate = functionNode.get(0)) instanceof VarNode) {
                    VariableUsageInfo usageInfo;
                    ConstantNode valueNode;
                    IConstant<IV> value;
                    VarNode varNode = (VarNode)varNodeCandidate;
                    IVariable<IV> var = varNode.getValueExpression();
                    BOp bOp = functionNode.get(1);
                    if (bOp instanceof ConstantNode && ((IV)(value = (valueNode = (ConstantNode)bOp).getValueExpression()).get()).isURI() && (usageInfo = VariableUsageInfo.merge(ancOrSelfVarUsageInfo, childVarUsageInfo)).varUsed(var)) {
                        inlineTasks.add(new InlineTasks(var, value, usageInfo.getVarUsages(var)));
                    }
                }
            }
            if (!(child instanceof IBindingProducerNode) || !StaticAnalysis.isMinusOrOptional(child)) continue;
            sa.getMaybeProducedBindings((IBindingProducerNode)((Object)child), optOrMinusVars, true);
        }
        for (IGroupMemberNode node : toRemove) {
            while (group.removeArg(node)) {
            }
        }
        for (IGroupMemberNode child : group) {
            if (child instanceof GroupNodeBase) {
                this.optimize(sa, (GroupNodeBase)child, staticBindingInfo, ancOrSelfVarUsageInfo, inlineTasks);
                continue;
            }
            if (!(child instanceof SubqueryRoot)) continue;
            this.optimize(sa, (SubqueryRoot)child, new StaticBindingInfo(), new VariableUsageInfo(), new HashSet<InlineTasks>());
        }
    }

    public static class InlineTasks {
        private final IVariable var;
        private final IConstant<IV> val;
        private final List<IQueryNode> nodes;

        public InlineTasks(IVariable var, IConstant<IV> val, List<IQueryNode> nodes) {
            this.var = var;
            this.nodes = nodes;
            this.val = val;
        }

        public IVariable getVar() {
            return this.var;
        }

        public void apply() {
            IV valIV = (IV)this.val.get();
            for (IQueryNode node : this.nodes) {
                this.apply(valIV, node);
            }
        }

        private void apply(IV val, IQueryNode node) {
            if (node instanceof FilterNode) {
                FilterNode filter = (FilterNode)node;
                IValueExpressionNode vexpr = filter.getValueExpressionNode();
                this.applyToValueExpressionNode(val, vexpr);
            } else if (node instanceof AssignmentNode) {
                this.applyToAssignmentNode(val, (AssignmentNode)node);
            } else if (node instanceof StatementPatternNode) {
                this.applyToStatementPattern(val, (StatementPatternNode)node);
            } else {
                throw new IllegalArgumentException("Unexpected node type for " + node);
            }
        }

        private void applyToAssignmentNode(IV val, AssignmentNode an) {
            IValueExpressionNode vexpr = an.getValueExpressionNode();
            this.applyToValueExpressionNode(val, vexpr);
        }

        private void applyToStatementPattern(IV val, StatementPatternNode spn) {
            ConstantNode constNode;
            TermNode s = spn.s();
            TermNode p = spn.p();
            TermNode o = spn.o();
            TermNode c = spn.c();
            if (s != null && s instanceof VarNode && s.get(0).equals(this.var)) {
                VarNode sVar = (VarNode)s;
                constNode = new ConstantNode(new Constant<IV>(sVar.getValueExpression(), val));
                spn.setArg(0, constNode);
            }
            if (p != null && p instanceof VarNode && p.get(0).equals(this.var)) {
                VarNode pVar = (VarNode)p;
                constNode = new ConstantNode(new Constant<IV>(pVar.getValueExpression(), val));
                spn.setArg(1, constNode);
            }
            if (o != null && o instanceof VarNode && o.get(0).equals(this.var)) {
                VarNode oVar = (VarNode)o;
                constNode = new ConstantNode(new Constant<IV>(oVar.getValueExpression(), val));
                spn.setArg(2, constNode);
            }
            if (c != null && c instanceof VarNode && c.get(0).equals(this.var)) {
                VarNode cVar = (VarNode)c;
                constNode = new ConstantNode(new Constant<IV>(cVar.getValueExpression(), val));
                spn.setArg(3, constNode);
            }
        }

        private void applyToValueExpressionNode(IV val, IValueExpressionNode vexpr) {
            if (vexpr == null || !(vexpr instanceof FunctionNode)) {
                return;
            }
            FunctionNode functionNode = (FunctionNode)vexpr;
            for (int i = 0; i < functionNode.arity(); ++i) {
                IValueExpressionNode cur = (IValueExpressionNode)functionNode.get(i);
                if (cur instanceof VarNode && ((VarNode)cur).get(0).equals(this.var)) {
                    ConstantNode constNode = new ConstantNode(new Constant<IV>(((VarNode)cur).getValueExpression(), val));
                    functionNode.setArg(i, constNode);
                    continue;
                }
                this.applyToValueExpressionNode(val, cur);
            }
        }
    }

    public static class StaticBindingInfo {
        final List<List<IBindingSet>> produced = new ArrayList<List<IBindingSet>>();
        final IBindingSet[] queryInput;

        public StaticBindingInfo() {
            this.queryInput = new IBindingSet[]{new ListBindingSet()};
        }

        public StaticBindingInfo(IBindingSet[] queryInput) {
            this.queryInput = queryInput;
        }

        public void addProduced(IBindingSet bs) {
            this.produced.add(this.wrap(bs));
        }

        public void addProduced(List<IBindingSet> bsList) {
            this.produced.add(bsList);
        }

        public List<List<IBindingSet>> getProduced() {
            return this.produced;
        }

        public IBindingSet[] joinProduced() {
            return this.join(this.produced);
        }

        private List<IBindingSet> wrap(IBindingSet bs) {
            ArrayList<IBindingSet> bsList = new ArrayList<IBindingSet>();
            bsList.add(bs);
            return bsList;
        }

        private IBindingSet[] join(List<List<IBindingSet>> staticBindings) {
            if (this.queryInput == null || this.queryInput.length == 0) {
                return this.queryInput;
            }
            List<IBindingSet> leftBindingSets = Arrays.asList(this.queryInput);
            for (List<IBindingSet> staticBinding : staticBindings) {
                LinkedList<IBindingSet> tmp = new LinkedList<IBindingSet>();
                for (IBindingSet left : leftBindingSets) {
                    for (IBindingSet right : staticBinding) {
                        IBindingSet join = BOpContext.bind(left, right, null, null);
                        if (join == null) continue;
                        tmp.add(join);
                    }
                }
                leftBindingSets = tmp;
            }
            return leftBindingSets.toArray(new IBindingSet[leftBindingSets.size()]);
        }
    }

    public static class VariableUsageInfo {
        final Map<IVariable<?>, List<IQueryNode>> usageMap = new HashMap();

        public boolean varUsedInFilterOrAssignment(IVariable<?> var) {
            if (!this.usageMap.containsKey(var)) {
                return false;
            }
            List<IQueryNode> varOccurrences = this.usageMap.get(var);
            for (int i = 0; i < varOccurrences.size(); ++i) {
                IQueryNode n = varOccurrences.get(i);
                if (!(n instanceof FilterNode) && !(n instanceof AssignmentNode)) continue;
                return true;
            }
            return false;
        }

        public boolean varUsed(IVariable<?> var) {
            return this.usageMap.containsKey(var) && !this.usageMap.get(var).isEmpty();
        }

        public List<IQueryNode> getVarUsages(IVariable<?> var) {
            return this.usageMap.get(var);
        }

        public Map<IVariable<?>, List<IQueryNode>> getUsageMap() {
            return this.usageMap;
        }

        public void extractVarUsageInfoSelf(GroupNodeBase<?> group) {
            for (IQueryNode node : group) {
                if (node instanceof FilterNode || node instanceof AssignmentNode) {
                    GroupMemberValueExpressionNodeBase filter = (GroupMemberValueExpressionNodeBase)node;
                    IValueExpressionNode vexpr = filter.getValueExpressionNode();
                    this.extractVarUsageInfo(node, vexpr);
                    continue;
                }
                if (!(node instanceof StatementPatternNode)) continue;
                StatementPatternNode spn = (StatementPatternNode)node;
                for (IVariable<?> spnVar : spn.getProducedBindings()) {
                    if (!this.usageMap.containsKey(spnVar)) {
                        this.usageMap.put(spnVar, new ArrayList());
                    }
                    this.usageMap.get(spnVar).add(node);
                }
            }
        }

        private void extractVarUsageInfo(IQueryNode node, IValueExpressionNode vexpNode) {
            if (vexpNode instanceof VarNode) {
                VarNode varNode = (VarNode)vexpNode;
                IVariable<IV> iVar = varNode.getValueExpression();
                if (!this.usageMap.containsKey(iVar)) {
                    this.usageMap.put(iVar, new ArrayList());
                }
                this.usageMap.get(iVar).add(node);
                return;
            }
            BOp nodeAsBop = (BOp)vexpNode;
            int arity = nodeAsBop.arity();
            for (int i = 0; i < arity; ++i) {
                BOp child = nodeAsBop.get(i);
                if (!(child instanceof IValueExpressionNode)) continue;
                this.extractVarUsageInfo(node, (IValueExpressionNode)child);
            }
        }

        public void extractVarSPUsageInfoChildren(GroupNodeBase<?> group) {
            for (IQueryNode child : group) {
                if (!(child instanceof GroupNodeBase)) continue;
                this.extractVarSPUsageInfoChildrenOrSelf((GroupNodeBase)child);
            }
        }

        public void extractVarSPUsageInfoChildrenOrSelf(GroupNodeBase<?> group) {
            if (group == null) {
                return;
            }
            if (group instanceof JoinGroupNode && ((JoinGroupNode)group).isOptional()) {
                return;
            }
            for (IQueryNode child : group) {
                if (child instanceof GroupNodeBase) {
                    this.extractVarSPUsageInfoChildrenOrSelf((GroupNodeBase)child);
                    continue;
                }
                if (child instanceof StatementPatternNode) {
                    StatementPatternNode spn = (StatementPatternNode)child;
                    for (IVariable<?> spnVar : spn.getProducedBindings()) {
                        if (!this.usageMap.containsKey(spnVar)) {
                            this.usageMap.put(spnVar, new ArrayList());
                        }
                        this.usageMap.get(spnVar).add(child);
                    }
                    continue;
                }
                if (!(child instanceof GroupNodeBase)) continue;
                this.extractVarSPUsageInfoChildrenOrSelf((GroupNodeBase)child);
            }
        }

        public static VariableUsageInfo merge(VariableUsageInfo x, VariableUsageInfo y) {
            VariableUsageInfo merged = new VariableUsageInfo();
            Map<IVariable<?>, List<IQueryNode>> usageMap = merged.getUsageMap();
            Map<IVariable<?>, List<IQueryNode>> xUsageMap = x.getUsageMap();
            for (IVariable<?> var : xUsageMap.keySet()) {
                if (!usageMap.containsKey(var)) {
                    usageMap.put(var, new ArrayList());
                }
                usageMap.get(var).addAll((Collection<IQueryNode>)xUsageMap.get(var));
            }
            Map<IVariable<?>, List<IQueryNode>> yUsageMap = y.getUsageMap();
            for (IVariable<?> var : yUsageMap.keySet()) {
                if (!usageMap.containsKey(var)) {
                    usageMap.put(var, new ArrayList());
                }
                usageMap.get(var).addAll((Collection<IQueryNode>)yUsageMap.get(var));
            }
            return merged;
        }
    }
}

