/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinSetUtil;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ASTHashJoinOptimizer
implements IASTOptimizer {
    private static final Logger log = Logger.getLogger(ASTHashJoinOptimizer.class);

    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        if (namedSubqueries != null) {
            for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
                this.optimizeJoinGroups(context, sa, namedSubquery.getWhereClause());
            }
        }
        this.optimizeJoinGroups(context, sa, queryRoot.getWhereClause());
        return new QueryNodeWithBindingSet(queryRoot, bindingSets);
    }

    private void optimizeJoinGroups(IEvaluationContext context, StaticAnalysis sa, GraphPatternGroup<IGroupMemberNode> group) {
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = group.get(i);
            if (child instanceof GraphPatternGroup) {
                this.optimizeJoinGroups(context, sa, (GraphPatternGroup)child);
                continue;
            }
            if (!(child instanceof ServiceNode)) continue;
        }
        JoinSetUtil joinSets = new JoinSetUtil(sa, null, group);
        if (joinSets.joinFilters.isEmpty()) {
            return;
        }
        int directJoinSetCount = joinSets.directJoinSets.size();
        if (directJoinSetCount > 1) {
            JoinSetUtil.VertexJoinSet[] a = joinSets.directJoinSets.toArray(new JoinSetUtil.VertexJoinSet[directJoinSetCount]);
            Arrays.sort(a, new VertexJoinSetComparator());
            for (int i = 0; i < a.length; ++i) {
                for (int j = i + 1; j < a.length; ++j) {
                    Set<IVariable<?>> set1 = a[i].joinvars;
                    Set<IVariable<?>> set2 = a[j].joinvars;
                    LinkedHashSet joinvars = new LinkedHashSet();
                    joinvars.addAll(set1);
                    joinvars.addAll(set2);
                    for (FilterNode f : joinSets.joinFilters) {
                        if (sa.isFullyBound(f, set1) || sa.isFullyBound(f, set2) || !sa.isFullyBound(f, joinvars)) continue;
                        log.error((Object)("indirect join: joinSet1=" + a[i] + ",joinSet2=" + a[j] + " on filter=" + f));
                    }
                }
            }
        }
    }

    private static class VertexJoinSetComparator
    implements Comparator<JoinSetUtil.VertexJoinSet> {
        private VertexJoinSetComparator() {
        }

        @Override
        public int compare(JoinSetUtil.VertexJoinSet o1, JoinSetUtil.VertexJoinSet o2) {
            return o2.vertices.size() - o1.vertices.size();
        }
    }
}

