/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.EmptyBindingSet;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.btree.BTree;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import com.bigdata.relation.accesspath.EmptyCloseableIterator;
import com.bigdata.relation.accesspath.ThickCloseableIterator;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class SliceServiceFactory
extends AbstractServiceFactory {
    private static final Logger log = Logger.getLogger(SliceServiceFactory.class);
    public static final URI SERVICE_KEY = new URIImpl("http://www.bigdata.com/rdf#slice");
    private static final ConcurrentWeakValueCacheWithTimeout<IPredicate<ISPO>, CacheHit> cache = new ConcurrentWeakValueCacheWithTimeout(100, TimeUnit.MINUTES.toMillis(1L));
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    @Override
    public BigdataNativeServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    @Override
    public BigdataServiceCall create(ServiceCallCreateParams params, ServiceParams serviceParams) {
        AbstractTripleStore store = params.getTripleStore();
        ServiceNode serviceNode = params.getServiceNode();
        StatementPatternNode sp = this.verifyGraphPattern(store, serviceNode.getGraphPattern(), serviceParams);
        return new SliceCall(store, sp, this.serviceOptions, serviceParams);
    }

    private StatementPatternNode verifyGraphPattern(AbstractTripleStore database, GroupNodeBase<IGroupMemberNode> group, ServiceParams params) {
        Iterator<Map.Entry<URI, List<TermNode>>> it = params.iterator();
        while (it.hasNext()) {
            URI param = it.next().getKey();
            if (SliceParams.OFFSET.equals((Object)param)) {
                if (params.getAsLong(param, null) != null) continue;
                throw new RuntimeException("must provide a value for: " + param);
            }
            if (SliceParams.LIMIT.equals((Object)param)) {
                if (params.getAsInt(param, null) != null) continue;
                throw new RuntimeException("must provide a value for: " + param);
            }
            if (SliceParams.RANGE.equals((Object)param)) {
                if (params.getAsVar(param, null) != null) continue;
                throw new RuntimeException("must provide a variable for: " + param);
            }
            throw new RuntimeException("unrecognized param: " + param);
        }
        StatementPatternNode sp = null;
        for (IGroupMemberNode node : group) {
            if (node instanceof FilterNode) continue;
            if (!(node instanceof StatementPatternNode)) {
                throw new RuntimeException("only statement patterns allowed");
            }
            StatementPatternNode tmp = (StatementPatternNode)node;
            if (tmp.s().isConstant() && BD.SERVICE_PARAM.equals((Object)tmp.s().getValue())) continue;
            if (sp != null) {
                throw new RuntimeException("group must contain a single statement pattern");
            }
            sp = tmp;
        }
        return sp;
    }

    private static class SliceCall
    implements BigdataServiceCall {
        private final AbstractTripleStore db;
        private final StatementPatternNode sp;
        private final IServiceOptions serviceOptions;
        private final ServiceParams serviceParams;

        public SliceCall(AbstractTripleStore db, StatementPatternNode sp, IServiceOptions serviceOptions, ServiceParams serviceParams) {
            if (db == null) {
                throw new IllegalArgumentException();
            }
            if (sp == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            if (serviceParams == null) {
                throw new IllegalArgumentException();
            }
            this.db = db;
            this.sp = sp;
            this.serviceOptions = serviceOptions;
            this.serviceParams = serviceParams;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bc) {
            long toIndex;
            long fromIndex;
            long endIndex;
            long startIndex;
            IPredicate<ISPO> pred;
            RangeBOp rangeBOp;
            IVariable v;
            if (log.isInfoEnabled()) {
                log.info((Object)bc.length);
                log.info((Object)Arrays.toString(bc));
            }
            if (bc != null && bc.length > 1) {
                throw new RuntimeException("cannot run with multiple incoming bindings");
            }
            LinkedHashMap<IVariable, Integer> vars = new LinkedHashMap<IVariable, Integer>();
            for (int i = 0; i < this.sp.arity(); ++i) {
                TermNode term = this.sp.get(i);
                if (term == null || !term.isVariable()) continue;
                v = (IVariable)term.getValueExpression();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("variable: " + v + " at position: " + i));
                }
                vars.put(v, i);
            }
            IBindingSet bs = bc.length == 1 && !bc[0].equals((Object)EmptyBindingSet.INSTANCE) ? bc[0] : null;
            if (bs != null) {
                Iterator it = bs.vars();
                while (it.hasNext()) {
                    v = (IVariable)it.next();
                    if (!vars.containsKey(v)) {
                        throw new RuntimeException("unrecognized variable in incoming binding");
                    }
                    if (!bs.isBound(v)) continue;
                    vars.remove(v);
                }
            }
            RangeBOp rangeBOp2 = rangeBOp = this.sp.getRange() != null ? this.sp.getRange().getRangeBOp() : null;
            if (log.isTraceEnabled()) {
                log.trace((Object)("range: " + rangeBOp));
            }
            if ((pred = this.db.getSPORelation().getPredicate(this.getTerm(this.sp, bs, 0), this.getTerm(this.sp, bs, 1), this.getTerm(this.sp, bs, 2), this.getTerm(this.sp, bs, 3), null, rangeBOp)) == null) {
                return new EmptyCloseableIterator<IBindingSet>();
            }
            IKeyOrder keyOrder = this.db.getSPORelation().getKeyOrder((IPredicate)pred);
            BTree ndx = (BTree)this.db.getSPORelation().getIndex(keyOrder);
            CacheHit hit = (CacheHit)cache.get(pred);
            if (hit == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"going to index for range");
                }
                byte[] startKey = ((SPOKeyOrder)keyOrder).getFromKey(KeyBuilder.newInstance(), pred);
                startIndex = this.indexOf(ndx, startKey);
                byte[] endKey = ((SPOKeyOrder)keyOrder).getToKey(KeyBuilder.newInstance(), pred);
                endIndex = this.indexOf(ndx, endKey) - 1L;
                cache.put(pred, (Object)new CacheHit(startIndex, endIndex));
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"cache hit");
                }
                startIndex = hit.startIndex;
                endIndex = hit.endIndex;
            }
            long range = endIndex - startIndex + 1L;
            if (log.isTraceEnabled()) {
                log.trace((Object)("range: " + range));
            }
            if (this.serviceParams.contains(SliceParams.RANGE)) {
                IVariable<IV> v2 = this.serviceParams.getAsVar(SliceParams.RANGE);
                IBindingSet[] bSets = new IBindingSet[]{bs != null ? bs.clone() : new ListBindingSet()};
                bSets[0].set(v2, new Constant(new XSDNumericIV(range)));
                return new ThickCloseableIterator<IBindingSet>(bSets, 1);
            }
            long offset = this.serviceParams.getAsLong(SliceParams.OFFSET, 0L);
            if (offset < 0L) {
                throw new RuntimeException("illegal negative offset");
            }
            if (offset > range) {
                throw new RuntimeException("offset is out of range");
            }
            int limit = this.serviceParams.getAsInt(SliceParams.LIMIT, 1000);
            if (log.isTraceEnabled()) {
                log.trace((Object)("offset: " + offset));
                log.trace((Object)("limit: " + limit));
            }
            if ((fromIndex = Math.max(startIndex, startIndex + offset)) > (toIndex = Math.min(startIndex + offset + (long)limit - 1L, endIndex))) {
                throw new RuntimeException("fromIndex > toIndex");
            }
            byte[] fromKey = ndx.keyAt(fromIndex);
            byte[] toKey = SuccessorUtil.successor(ndx.keyAt(toIndex));
            int arity = pred.arity();
            int numBoundEntries = pred.arity() - vars.size();
            if (log.isTraceEnabled()) {
                log.trace((Object)("fromIndex: " + fromIndex));
                log.trace((Object)("toIndex: " + toIndex));
                log.trace((Object)("fromKey: " + BytesUtil.toString((byte[])fromKey)));
                log.trace((Object)("toKey: " + BytesUtil.toString((byte[])toKey)));
                log.trace((Object)("arity: " + arity));
                log.trace((Object)("#boundEntries: " + numBoundEntries));
                log.trace((Object)keyOrder);
            }
            IFilter advancer = null;
            ITupleIterator it = ndx.rangeIterator(fromKey, toKey, 0, 33, advancer);
            IBindingSet[] bSets = new IBindingSet[limit];
            int i = 0;
            while (it.hasNext()) {
                byte[] key = it.next().getKey();
                SPO spo = ((SPOKeyOrder)keyOrder).decodeKey(key);
                bSets[i] = bs != null ? bs.clone() : new ListBindingSet();
                for (IVariable v3 : vars.keySet()) {
                    int pos = (Integer)vars.get(v3);
                    bSets[i].set(v3, new Constant<IV>(spo.get(pos)));
                }
                ++i;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done iterating " + i + " results."));
            }
            return new ThickCloseableIterator<IBindingSet>(bSets, i);
        }

        private IV getTerm(StatementPatternNode sp, IBindingSet bs, int pos) {
            TermNode t = sp.get(pos);
            if (t == null) {
                return null;
            }
            if (t.isConstant()) {
                return (IV)((IConstant)t.getValueExpression()).get();
            }
            IVariable v = (IVariable)t.getValueExpression();
            if (bs != null && bs.isBound(v)) {
                return (IV)bs.get(v).get();
            }
            return null;
        }

        private long indexOf(BTree ndx, byte[] key) {
            if (log.isTraceEnabled()) {
                log.trace((Object)BytesUtil.toString((byte[])key));
            }
            long indexOfKey = ndx.indexOf(key);
            if (log.isTraceEnabled()) {
                log.trace((Object)("result of indexOf(key): " + indexOfKey));
            }
            long index = indexOfKey >= 0L ? indexOfKey : -(indexOfKey + 1L);
            if (log.isTraceEnabled()) {
                log.trace((Object)("index: " + index));
            }
            return index;
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }
    }

    private static final class CacheHit {
        final long startIndex;
        final long endIndex;

        public CacheHit(long startIndex, long endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }

    public static interface SliceParams {
        public static final URI OFFSET = new URIImpl(SERVICE_KEY.stringValue() + ".offset");
        public static final long DEFAULT_OFFSET = 0L;
        public static final URI LIMIT = new URIImpl(SERVICE_KEY.stringValue() + ".limit");
        public static final int DEFAULT_LIMIT = 1000;
        public static final URI RANGE = new URIImpl(SERVICE_KEY.stringValue() + ".range");
    }
}

