/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IReorderableNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.optimizers.StaticOptimizer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UnionNode
extends GraphPatternGroup<JoinGroupNode>
implements IReorderableNode {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(UnionNode.class);

    public UnionNode(UnionNode op) {
        super(op);
    }

    public UnionNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        for (BOp x : args) {
            assert (x instanceof JoinGroupNode);
        }
    }

    public UnionNode() {
    }

    public UnionNode addChild(JoinGroupNode child) {
        JoinGroupNode group = child;
        if (group.isOptional()) {
            log.warn((Object)"optional tag on child will be ignored");
        }
        return (UnionNode)super.addChild(child);
    }

    @Override
    public final boolean isOptional() {
        return false;
    }

    @Override
    public final boolean isMinus() {
        return false;
    }

    @Override
    public long getEstimatedCardinality(StaticOptimizer optimizer) {
        long cardinality = 0L;
        for (JoinGroupNode child : this) {
            StaticOptimizer opt = new StaticOptimizer(optimizer, child.getReorderableChildren());
            cardinality += opt.getCardinality();
        }
        return cardinality;
    }

    @Override
    public boolean isReorderable() {
        for (JoinGroupNode child : this) {
            for (IGroupMemberNode grandchild : child) {
                if (grandchild instanceof FilterNode) continue;
                if (!(grandchild instanceof IReorderableNode)) {
                    return false;
                }
                if (((IReorderableNode)grandchild).isReorderable()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void addArg(BOp newArg) {
        assert (newArg instanceof JoinGroupNode);
        super.addArg(newArg);
    }

    @Override
    public void addArg(int index, BOp newArg) {
        assert (newArg instanceof JoinGroupNode);
        super.addArg(index, newArg);
    }

    @Override
    public int replaceWith(BOp oldChild, BOp newChild) {
        assert (newChild instanceof JoinGroupNode);
        return super.replaceWith(oldChild, newChild);
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(StaticAnalysis sa) {
        HashSet requiredBound = new HashSet();
        for (JoinGroupNode jgn : this.getChildren()) {
            requiredBound.addAll(jgn.getRequiredBound(sa));
        }
        return requiredBound;
    }

    @Override
    public Set<IVariable<?>> getDesiredBound(StaticAnalysis sa) {
        HashSet desiredBound = new HashSet();
        for (JoinGroupNode jgn : this.getChildren()) {
            desiredBound.addAll(jgn.getDesiredBound(sa));
        }
        return desiredBound;
    }
}

