/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.IDataSetNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IPrefixDecls;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryType;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class QueryRoot
extends QueryBase
implements IPrefixDecls,
IDataSetNode {
    private static final long serialVersionUID = 1L;

    public QueryRoot(QueryRoot queryRoot) {
        super(queryRoot);
    }

    public QueryRoot(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public QueryRoot(QueryType queryType) {
        super(queryType);
    }

    public void setParent(IGroupNode<?> parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> getPrefixDecls() {
        Map prefixDecls = (Map)this.getProperty("prefixDecls");
        if (prefixDecls == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(prefixDecls);
    }

    @Override
    public void setPrefixDecls(Map<String, String> prefixDecls) {
        this.setProperty("prefixDecls", prefixDecls);
    }

    @Override
    public void setDataset(DatasetNode dataset) {
        this.setProperty("dataset", dataset);
    }

    @Override
    public DatasetNode getDataset() {
        return (DatasetNode)this.getProperty("dataset");
    }

    public NamedSubqueriesNode getNamedSubqueries() {
        return (NamedSubqueriesNode)this.getProperty("namedSubqueries");
    }

    public NamedSubqueriesNode getNamedSubqueriesNotNull() {
        NamedSubqueriesNode tmp = (NamedSubqueriesNode)this.getProperty("namedSubqueries");
        if (tmp == null) {
            tmp = new NamedSubqueriesNode();
            this.setProperty("namedSubqueries", tmp);
        }
        return tmp;
    }

    public void setNamedSubqueries(NamedSubqueriesNode namedSubqueries) {
        this.setProperty("namedSubqueries", namedSubqueries);
    }

    @Override
    public String toString(int indent) {
        return this.toString(indent, null);
    }

    public String toString(int indent, IBindingSet[] bs) {
        String s = QueryRoot.indent(indent);
        StringBuilder sb = new StringBuilder();
        Properties queryHints = this.getQueryHints();
        Map<String, String> prefixDecls = this.getPrefixDecls();
        DatasetNode dataset = this.getDataset();
        NamedSubqueriesNode namedSubqueries = this.getNamedSubqueries();
        if (queryHints != null) {
            Enumeration<?> eitr = queryHints.propertyNames();
            while (eitr.hasMoreElements()) {
                String key = (String)eitr.nextElement();
                sb.append("\n");
                sb.append(s);
                sb.append("hint: [" + key + "]=[" + queryHints.getProperty(key) + "]");
            }
        }
        if (prefixDecls != null) {
            for (Map.Entry<String, String> e : prefixDecls.entrySet()) {
                sb.append("\n");
                sb.append(s);
                sb.append("PREFIX ");
                sb.append(e.getKey());
                sb.append(": <");
                sb.append(e.getValue());
                sb.append(">");
            }
        }
        if (dataset != null) {
            sb.append(dataset.toString(indent + 1));
        }
        if (namedSubqueries != null && !namedSubqueries.isEmpty()) {
            sb.append(namedSubqueries.toString(indent));
        }
        sb.append(super.toString(indent));
        if (bs != null) {
            sb.append("\n\nwith static (exogeneous) bindings defined as follows: \n");
            sb.append("{");
            for (int i = 0; i < bs.length && i <= 10; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("\n  ");
                sb.append(bs[i].toString());
            }
            if (bs.length > 10) {
                sb.append(",\n");
                sb.append("  ... (");
                sb.append(bs.length - 10);
                sb.append(" more)\n");
            } else {
                sb.append("\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    public static interface Annotations
    extends QueryBase.Annotations,
    IPrefixDecls.Annotations,
    IDataSetNode.Annotations {
        public static final String NAMED_SUBQUERIES = "namedSubqueries";
    }
}

