/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.sparql.ast.INamedSolutionSet;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Map;

public class NamedSubqueryRoot
extends SubqueryBase
implements INamedSolutionSet {
    private static final long serialVersionUID = 1L;

    public NamedSubqueryRoot(NamedSubqueryRoot queryBase) {
        super(queryBase);
    }

    public NamedSubqueryRoot(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public NamedSubqueryRoot(QueryType queryType, String name) {
        super(queryType);
        this.setName(name);
    }

    @Override
    public String getName() {
        return (String)this.getProperty("namedSet");
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("namedSet", name);
    }

    public VarNode[] getJoinVars() {
        return (VarNode[])this.getProperty("joinVars");
    }

    public void setJoinVars(VarNode[] joinVars) {
        this.setProperty("joinVars", joinVars);
    }

    public final String[] getDependsOn() {
        return (String[])this.getRequiredProperty("dependsOn");
    }

    public final void setDependsOn(String[] dependsOn) {
        this.setProperty("dependsOn", dependsOn);
    }

    @Override
    public String toString(int indent) {
        String[] dependsOn;
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(NamedSubqueryRoot.indent(indent));
        sb.append("WITH {");
        sb.append(super.toString(indent + 1));
        sb.append("\n");
        sb.append(NamedSubqueryRoot.indent(indent));
        sb.append("} AS ").append(this.getName());
        VarNode[] joinVars = this.getJoinVars();
        if (joinVars != null) {
            sb.append(" JOIN ON (");
            boolean first = true;
            for (VarNode var : joinVars) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(var);
                first = false;
            }
            sb.append(")");
        }
        if ((dependsOn = (String[])this.getProperty("dependsOn")) != null) {
            sb.append(" DEPENDS ON (");
            boolean first = true;
            for (String s : dependsOn) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(s);
                first = false;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public static interface Annotations
    extends INamedSolutionSet.Annotations {
        public static final String DEPENDS_ON = "dependsOn";
        public static final String JOIN_VARS = "joinVars";
        public static final String DONE_SET = "doneSet";
    }
}

