/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Bind;
import com.bigdata.bop.IBind;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IValueExpressionConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.ImmutableBOp;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.bop.aggregate.IAggregate;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.SPARQLConstraint;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import cutthecrap.utils.striterators.Striterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class VerifyAggregates {
    private static final Logger log = Logger.getLogger(VerifyAggregates.class);
    private final IValueExpression<?>[] select;
    private final IValueExpression<?>[] groupBy;
    private final IConstraint[] having;
    private final LinkedHashSet<IVariable<?>> groupByVars = new LinkedHashSet();
    private final LinkedHashSet<IVariable<?>> selectVars = new LinkedHashSet();
    private final LinkedHashSet<IVariable<?>> columnVars = new LinkedHashSet();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{select=" + Arrays.toString(this.select));
        sb.append(",groupBy=" + Arrays.toString(this.groupBy));
        sb.append(",having=" + Arrays.toString(this.having));
        sb.append("}");
        return sb.toString();
    }

    public VerifyAggregates(ProjectionNode projection, GroupByNode groupBy, HavingNode having) {
        IValueExpressionNode exprNode;
        int i;
        IValueExpression[] iValueExpressionArray = this.groupBy = groupBy == null || groupBy.arity() == 0 ? null : groupBy.getValueExpressions();
        if (projection != null) {
            IValueExpression[] exprs = new IValueExpression[projection.arity()];
            i = 0;
            Striterator projectionNodes = new Striterator(projection.iterator());
            while (projectionNodes.hasMoreElements()) {
                AssignmentNode assignmentNode = (AssignmentNode)projectionNodes.nextElement();
                IValueExpression expr = assignmentNode.getValueExpression();
                exprNode = assignmentNode.getValueExpressionNode();
                if (expr == null && exprNode instanceof FunctionNode) {
                    expr = this.convertAggregates((FunctionNode)exprNode);
                }
                exprs[i++] = new Bind<IV>(assignmentNode.getVar(), expr);
            }
            this.select = exprs;
        } else {
            this.select = null;
        }
        if (projection == null) {
            throw new IllegalArgumentException();
        }
        if (projection.arity() == 0) {
            throw new IllegalArgumentException();
        }
        if (having != null) {
            IConstraint[] exprs2 = new IConstraint[having.arity()];
            i = 0;
            for (IValueExpressionNode iValueExpressionNode : having) {
                IValueExpression<? extends IV> ve = iValueExpressionNode.getValueExpression();
                if (ve != null) {
                    exprs2[i] = new SPARQLConstraint(ve);
                } else if (iValueExpressionNode instanceof FunctionNode) {
                    exprNode = (FunctionNode)iValueExpressionNode;
                    IValueExpression iValueExpression = this.convertAggregates((BOp)exprNode);
                    exprs2[i] = new SPARQLConstraint(new BOp[]{iValueExpression}, null);
                    log.debug((Object)("Unknown node " + iValueExpressionNode));
                }
                ++i;
            }
            this.having = exprs2;
        } else {
            this.having = null;
        }
        AtomicBoolean anyDistinct = new AtomicBoolean(false);
        AtomicBoolean nestedAggregates = new AtomicBoolean(false);
        if (groupBy != null) {
            for (IValueExpression<?> expr : this.groupBy) {
                if (expr instanceof IVariable) {
                    this.groupByVars.add((IVariable)expr);
                    continue;
                }
                if (!(expr instanceof IBind)) continue;
                IBind iBind = (IBind)expr;
                IValueExpression e = iBind.getExpr();
                if (this.isAggregate((BOp)e, false, null, nestedAggregates, anyDistinct)) {
                    throw new IllegalArgumentException("Aggregate expression not allowed in GROUP_BY: " + expr);
                }
                this.groupByVars.add(iBind.getVar());
            }
        }
        AtomicBoolean selectDependency = new AtomicBoolean(false);
        for (IValueExpression<?> iValueExpression : this.select) {
            if (iValueExpression instanceof IVariable) {
                IVariable var = (IVariable)iValueExpression;
                if (!this.groupByVars.contains(var)) {
                    throw new IllegalArgumentException("Bare variable not declared by GROUP_BY clause: " + var);
                }
                this.selectVars.add(var);
                continue;
            }
            if (iValueExpression instanceof IBind) {
                IBind bindExpr = (IBind)iValueExpression;
                IValueExpression e = bindExpr.getExpr();
                if (!this.isAggregate((BOp)e, true, selectDependency, nestedAggregates, anyDistinct)) {
                    throw new IllegalArgumentException("Not an aggregate: " + bindExpr);
                }
                this.selectVars.add(bindExpr.getVar());
                continue;
            }
            throw new IllegalArgumentException("Top-level of SELECT expression must be IVariable or IBind: " + iValueExpression);
        }
        boolean simpleHaving = true;
        if (having != null) {
            block4: for (IConstraint iConstraint : this.having) {
                if (!this.isAggregate(iConstraint, false, null, nestedAggregates, anyDistinct)) {
                    throw new IllegalArgumentException("Not an aggregate: " + iConstraint);
                }
                if (!simpleHaving) continue;
                IValueExpression expr = ((IValueExpressionConstraint)iConstraint).getValueExpression();
                Iterator<BOp> itr = BOpUtility.preOrderIterator(expr);
                while (itr.hasNext()) {
                    BOp t = itr.next();
                    if (!(t instanceof IAggregate)) continue;
                    simpleHaving = false;
                    continue block4;
                }
            }
        }
    }

    private IValueExpression convertAggregates(BOp exprNode) {
        BOp[] args = new BOp[exprNode.args().size()];
        if (exprNode != null && exprNode.arity() > 0) {
            for (int i = 0; i < exprNode.args().size(); ++i) {
                BOp arg = (BOp)exprNode.args().get(i);
                IValueExpression newValue = this.convertAggregates(arg);
                args[i] = newValue != null ? newValue : arg;
            }
        }
        ImmutableBOp expr = exprNode instanceof FunctionNode ? (exprNode instanceof FunctionNode && FunctionRegistry.isAggregate(((FunctionNode)exprNode).getFunctionURI()) ? new AggregateBase(args, null){

            @Override
            public void reset() {
            }

            @Override
            public IV done() {
                return null;
            }
        } : new FunctionRegistry.UnknownFunctionBOp(args, null)) : null;
        return expr;
    }

    protected boolean isAggregate(BOp op, boolean isSelectClause, AtomicBoolean isSelectDependency, AtomicBoolean isNestedAggregates, AtomicBoolean isAnyDistinct) {
        if (op == null) {
            return false;
        }
        if (op instanceof IConstant && isSelectClause) {
            return true;
        }
        return this.isAggregate(op, isSelectClause, isSelectDependency, isNestedAggregates, isAnyDistinct, false);
    }

    private boolean isAggregate(BOp op, boolean isSelectClause, AtomicBoolean isSelectDependency, AtomicBoolean isNestedAggregates, AtomicBoolean isAnyDistinct, boolean withinAggregateFunction) {
        boolean aggregationContext;
        if (op instanceof IAggregate || op instanceof FunctionNode && FunctionRegistry.isAggregate(((FunctionNode)op).getFunctionURI())) {
            if (withinAggregateFunction) {
                isNestedAggregates.set(true);
            }
            if (((IAggregate)op).isDistinct()) {
                isAnyDistinct.set(true);
            }
        }
        boolean isAggregate = aggregationContext = withinAggregateFunction || op instanceof IAggregate;
        BOp t = op;
        if (t instanceof IVariable) {
            IVariable v = (IVariable)t;
            if (aggregationContext) {
                if (!this.groupByVars.contains(v) && !this.selectVars.contains(v)) {
                    this.columnVars.add(v);
                }
                return false;
            }
            if (this.groupByVars.contains(v)) {
                isAggregate = true;
                return true;
            }
            if (this.selectVars.contains(v)) {
                if (isSelectClause) {
                    isSelectDependency.set(true);
                }
                isAggregate = true;
                return true;
            }
            if (isSelectClause) {
                throw new IllegalArgumentException("Non-aggregate variable in select expression: " + v);
            }
        }
        Iterator itr = op.argIterator();
        while (itr.hasNext()) {
            BOp arg = (BOp)itr.next();
            if (this.selectVars.contains(arg)) {
                if (isSelectClause) {
                    isSelectDependency.set(true);
                }
                isAggregate = true;
                return true;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("op=" + op.getClass() + ", isSelectClause=" + isSelectClause + ", isSelectDependency=" + isSelectDependency + ", isNestedAggregates=" + isNestedAggregates + ", isAnyDistinct=" + isAnyDistinct + ", withinAggregateFunction=" + withinAggregateFunction + ", aggregationContext=" + aggregationContext + ", groupByVars=" + this.groupByVars + ", selectVars=" + this.selectVars + ", arg=" + arg));
            }
            isAggregate |= this.isAggregate(arg, isSelectClause, isSelectDependency, isNestedAggregates, isAnyDistinct, aggregationContext);
        }
        return isAggregate;
    }

    public static void verifyAggregate(QueryBase queryBase) throws VisitorException {
        GroupByNode groupBy;
        ProjectionNode projection;
        ProjectionNode projectionNode = queryBase.getProjection() == null ? null : (projection = queryBase.getProjection().isEmpty() ? null : queryBase.getProjection());
        GroupByNode groupByNode = queryBase.getGroupBy() == null ? null : (groupBy = queryBase.getGroupBy().isEmpty() ? null : queryBase.getGroupBy());
        HavingNode having = queryBase.getHaving() == null ? null : (queryBase.getHaving().isEmpty() ? null : queryBase.getHaving());
        boolean isAggregate = StaticAnalysis.isAggregate(projection, groupBy, having);
        if (isAggregate) {
            if (projection.isWildcard()) {
                throw new VisitorException("Wildcard not allowed with aggregate.");
            }
            try {
                new VerifyAggregates(projection, groupBy, having);
            }
            catch (IllegalArgumentException ex) {
                throw new VisitorException("Bad aggregate", (Throwable)ex);
            }
        }
    }
}

