/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import java.io.File;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SailBase
implements Sail {
    protected static final long DEFAULT_CONNECTION_TIMEOUT = 20000L;
    static final String DEBUG_PROP = "org.openrdf.repository.debug";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile File dataDir;
    private volatile boolean initialized = false;
    protected final ReentrantReadWriteLock initializationLock = new ReentrantReadWriteLock();
    protected volatile long connectionTimeOut = 20000L;
    private final Map<SailConnection, Throwable> activeConnections = new IdentityHashMap<SailConnection, Throwable>();

    protected static boolean debugEnabled() {
        try {
            String value = System.getProperty(DEBUG_PROP);
            return value != null && !value.equals("false");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public void setDataDir(File dataDir) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.dataDir = dataDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public String toString() {
        if (this.dataDir == null) {
            return super.toString();
        }
        return this.dataDir.toString();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SailException {
        this.initializationLock.writeLock().lock();
        try {
            if (this.isInitialized()) {
                throw new IllegalStateException("sail has already been intialized");
            }
            this.initializeInternal();
            this.initialized = true;
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    protected void initializeInternal() throws SailException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws SailException {
        this.initializationLock.writeLock().lock();
        try {
            if (!this.isInitialized()) {
                return;
            }
            Map<SailConnection, Throwable> map = this.activeConnections;
            synchronized (map) {
                if (!this.activeConnections.isEmpty()) {
                    this.logger.debug("Waiting for active connections to close before shutting down...");
                    try {
                        this.activeConnections.wait(20000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                Iterator<Map.Entry<SailConnection, Throwable>> iter = this.activeConnections.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<SailConnection, Throwable> entry = iter.next();
                    SailConnection con = entry.getKey();
                    Throwable stackTrace = entry.getValue();
                    iter.remove();
                    if (stackTrace == null) {
                        this.logger.warn("Closing active connection due to shut down; consider setting the {} system property", (Object)DEBUG_PROP);
                    } else {
                        this.logger.warn("Closing active connection due to shut down, connection was acquired in", stackTrace);
                    }
                    try {
                        con.close();
                    }
                    catch (SailException e) {
                        this.logger.error("Failed to close connection", (Throwable)e);
                    }
                }
            }
            this.shutDownInternal();
        }
        finally {
            this.initialized = false;
            this.initializationLock.writeLock().unlock();
        }
    }

    protected abstract void shutDownInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SailConnection getConnection() throws SailException {
        this.initializationLock.readLock().lock();
        try {
            if (!this.isInitialized()) {
                throw new IllegalStateException("Sail is not initialized or has been shut down");
            }
            SailConnection connection = this.getConnectionInternal();
            Throwable stackTrace = SailBase.debugEnabled() ? new Throwable() : null;
            SailConnection sailConnection = this.activeConnections;
            synchronized (sailConnection) {
                this.activeConnections.put(connection, stackTrace);
            }
            sailConnection = connection;
            return sailConnection;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    protected abstract SailConnection getConnectionInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(SailConnection connection) {
        Map<SailConnection, Throwable> map = this.activeConnections;
        synchronized (map) {
            if (this.activeConnections.containsKey(connection)) {
                this.activeConnections.remove(connection);
                if (this.activeConnections.isEmpty()) {
                    this.activeConnections.notifyAll();
                }
            }
        }
    }
}

