/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.relation.rule.IProgram;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.Program;
import com.bigdata.relation.rule.Rule;
import java.util.Iterator;
import java.util.LinkedList;

public class TMUtility {
    public static final transient TMUtility INSTANCE = new TMUtility(true);
    public static final transient TMUtility DEBUG = new TMUtility(false);
    private final boolean parallel;

    public TMUtility(boolean parallel) {
        this.parallel = parallel;
    }

    public Program mapRuleForTruthMaintenance(IRule rule, String focusStore) {
        IConstraint[] constraints;
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        if (focusStore == null) {
            throw new IllegalArgumentException();
        }
        LinkedList rules = new LinkedList();
        int tailCount = rule.getTailCount();
        if (rule.getHead() == null) {
            throw new IllegalArgumentException("No head for this rule: rule=" + rule);
        }
        IPredicate head = rule.getHead() instanceof SPOPredicate ? rule.getHead().setRelationName(new String[]{focusStore}) : rule.getHead();
        IPredicate[] tail = new IPredicate[tailCount];
        Iterator<IPredicate> itr = rule.getTail();
        int i = 0;
        while (itr.hasNext()) {
            tail[i++] = itr.next();
        }
        int constraintCount = rule.getConstraintCount();
        if (constraintCount > 0) {
            constraints = new IConstraint[constraintCount];
            Iterator<IConstraint> itr2 = rule.getConstraints();
            int i2 = 0;
            while (itr2.hasNext()) {
                constraints[i2++] = itr2.next();
            }
        } else {
            constraints = null;
        }
        for (i = 0; i < tailCount; ++i) {
            IPredicate[] tail2 = new IPredicate[tailCount];
            for (int j = 0; j < tailCount; ++j) {
                IPredicate p = tail[j];
                IPredicate p2 = p instanceof SPOPredicate ? (i == j || tailCount == 1 ? p.setRelationName(new String[]{focusStore}) : p.setRelationName(new String[]{p.getOnlyRelationName(), focusStore})) : p;
                tail2[j] = p2;
            }
            Rule newRule = new Rule(rule.getName() + "[" + i + "]", head, tail2, rule.getQueryOptions(), constraints, rule.getConstants(), rule.getTaskFactory());
            rules.add(newRule);
        }
        Program program = new Program(rule.getName(), this.parallel);
        program.addSteps(rules.iterator());
        return program;
    }

    public Program mapProgramForTruthMaintenance(IProgram program, String focusStore) {
        if (program == null) {
            throw new IllegalArgumentException();
        }
        if (focusStore == null) {
            throw new IllegalArgumentException();
        }
        MyProgram tmp = new MyProgram(program.getName(), program.isParallel(), program.isClosure());
        Iterator<IStep> itr = program.steps();
        while (itr.hasNext()) {
            tmp.addSteps(this.mapForTruthMaintenance(itr.next(), focusStore).steps());
        }
        return tmp;
    }

    public Program mapForTruthMaintenance(IStep step, String focusStore) {
        if (step.isRule()) {
            return this.mapRuleForTruthMaintenance((IRule)step, focusStore);
        }
        return this.mapProgramForTruthMaintenance((IProgram)step, focusStore);
    }

    private static class MyProgram
    extends Program {
        private static final long serialVersionUID = 2466870779751510938L;

        protected MyProgram(String name, boolean parallel, boolean closure) {
            super(name, parallel, closure);
        }
    }
}

