/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.extensions.DateTimeExtension;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import com.bigdata.rdf.model.BNodeContextFactory;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataBNodeImpl;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataLiteralImpl;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataStatementImpl;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataURIImpl;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueImpl;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.util.concurrent.CanonicalFactory;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.BooleanLiteralImpl;

public class BigdataValueFactoryImpl
implements BigdataValueFactory {
    private final String namespace;
    private static CanonicalFactory<String, BigdataValueFactoryImpl, String> cache = new CanonicalFactory<String, BigdataValueFactoryImpl, String>(1){

        @Override
        protected BigdataValueFactoryImpl newInstance(String key, String namespace) {
            return new BigdataValueFactoryImpl(namespace);
        }
    };
    public static final transient String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final transient String xsd = "http://www.w3.org/2001/XMLSchema#";
    private final BigdataURIImpl xsd_string = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#string");
    private final BigdataURIImpl xsd_dateTime = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#dateTime");
    private final BigdataURIImpl xsd_date = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#date");
    private final BigdataURIImpl xsd_long = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#long");
    private final BigdataURIImpl xsd_int = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#int");
    private final BigdataURIImpl xsd_byte = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#byte");
    private final BigdataURIImpl xsd_short = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#short");
    private final BigdataURIImpl xsd_ulong = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#unsignedLong");
    private final BigdataURIImpl xsd_uint = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#unsignedInt");
    private final BigdataURIImpl xsd_ubyte = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#unsignedByte");
    private final BigdataURIImpl xsd_ushort = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#unsignedShort");
    private final BigdataURIImpl xsd_double = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#double");
    private final BigdataURIImpl xsd_float = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#float");
    private final BigdataURIImpl xsd_boolean = new BigdataURIImpl((BigdataValueFactory)this, "http://www.w3.org/2001/XMLSchema#boolean");
    private final Map<String, BigdataURIImpl> xsdMap;
    private final transient BigdataValueSerializer<BigdataValue> valueSer = new BigdataValueSerializer(this);

    @Override
    public String getNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        throw new RuntimeException("Headless value factory should not be asked for its namespace");
    }

    public BigdataValueFactoryImpl() {
        this(null);
    }

    private BigdataValueFactoryImpl(String namespace) {
        this.namespace = namespace;
        this.xsdMap = this.getXSDMap();
    }

    public static BigdataValueFactory getInstance(String namespace) {
        return cache.getInstance(namespace, namespace);
    }

    @Override
    public void remove() {
        cache.remove(this.namespace);
    }

    @Override
    public BNodeContextFactory newBNodeContext() {
        return new BNodeContextFactory(this);
    }

    @Override
    public BigdataBNodeImpl createBNode() {
        return this.createBNode(this.nextID());
    }

    protected String nextID() {
        return "u" + UUID.randomUUID();
    }

    @Override
    public BigdataBNodeImpl createBNode(String id) {
        return new BigdataBNodeImpl((BigdataValueFactory)this, id);
    }

    @Override
    public BigdataBNodeImpl createBNode(BigdataStatement stmt) {
        return new BigdataBNodeImpl(this, this.nextID(), stmt);
    }

    @Override
    public BigdataLiteralImpl createLiteral(String label) {
        return new BigdataLiteralImpl(this, label, null, null);
    }

    private Map<String, BigdataURIImpl> getXSDMap() {
        BigdataURIImpl[] a;
        LinkedHashMap<String, BigdataURIImpl> map = new LinkedHashMap<String, BigdataURIImpl>();
        for (BigdataURIImpl x : a = new BigdataURIImpl[]{this.xsd_string, this.xsd_dateTime, this.xsd_date, this.xsd_long, this.xsd_int, this.xsd_byte, this.xsd_short, this.xsd_double, this.xsd_float, this.xsd_boolean}) {
            map.put(x.stringValue(), x);
        }
        return map;
    }

    @Override
    public BigdataLiteralImpl createLiteral(boolean arg0) {
        return arg0 ? new BigdataLiteralImpl(this, "true", null, this.xsd_boolean) : new BigdataLiteralImpl(this, "false", null, this.xsd_boolean);
    }

    @Override
    public BigdataLiteralImpl createLiteral(byte arg0) {
        return new BigdataLiteralImpl(this, "" + arg0, null, this.xsd_byte);
    }

    @Override
    public BigdataLiteralImpl createLiteral(byte arg0, boolean unsigned) {
        return new BigdataLiteralImpl(this, "" + (unsigned ? XSDUnsignedByteIV.promote(arg0) : (short)arg0), null, unsigned ? this.xsd_ubyte : this.xsd_byte);
    }

    @Override
    public BigdataLiteralImpl createLiteral(short arg0) {
        return new BigdataLiteralImpl(this, "" + arg0, null, this.xsd_short);
    }

    @Override
    public BigdataLiteralImpl createLiteral(short arg0, boolean unsigned) {
        return new BigdataLiteralImpl(this, "" + (unsigned ? XSDUnsignedShortIV.promote((short)arg0) : arg0), null, unsigned ? this.xsd_ushort : this.xsd_short);
    }

    @Override
    public BigdataLiteralImpl createLiteral(int arg0) {
        return new BigdataLiteralImpl(this, "" + arg0, null, this.xsd_int);
    }

    @Override
    public BigdataLiteralImpl createLiteral(int arg0, boolean unsigned) {
        return new BigdataLiteralImpl(this, "" + (unsigned ? XSDUnsignedIntIV.promote(arg0) : (long)arg0), null, unsigned ? this.xsd_uint : this.xsd_int);
    }

    @Override
    public BigdataLiteralImpl createLiteral(long arg0) {
        return new BigdataLiteralImpl(this, "" + arg0, null, this.xsd_long);
    }

    @Override
    public BigdataLiteralImpl createLiteral(long arg0, boolean unsigned) {
        return new BigdataLiteralImpl(this, "" + (unsigned ? XSDUnsignedLongIV.promote(arg0) : Long.valueOf(arg0)), null, unsigned ? this.xsd_ulong : this.xsd_long);
    }

    @Override
    public BigdataLiteralImpl createLiteral(float arg0) {
        return new BigdataLiteralImpl(this, "" + arg0, null, this.xsd_float);
    }

    @Override
    public BigdataLiteralImpl createLiteral(double arg0) {
        return new BigdataLiteralImpl(this, "" + arg0, null, this.xsd_double);
    }

    @Override
    public BigdataLiteralImpl createLiteral(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar xmlGC = DateTimeExtension.datatypeFactorySingleton.newXMLGregorianCalendar(c);
        return this.createLiteral(xmlGC);
    }

    @Override
    public BigdataLiteralImpl createLiteral(XMLGregorianCalendar arg0) {
        return new BigdataLiteralImpl(this, arg0.toString(), null, this.createURI(XMLDatatypeUtil.qnameToURI((QName)arg0.getXMLSchemaType()).stringValue()));
    }

    @Override
    public BigdataLiteralImpl createXSDDateTime(long timestamp) {
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setGregorianChange(new Date(Long.MIN_VALUE));
        c.setTimeInMillis(timestamp);
        XMLGregorianCalendar xmlGC = DateTimeExtension.datatypeFactorySingleton.newXMLGregorianCalendar(c);
        return this.createLiteral(xmlGC);
    }

    @Override
    public BigdataLiteralImpl createLiteral(String label, String language) {
        return new BigdataLiteralImpl(this, label, language, null);
    }

    @Override
    public BigdataLiteralImpl createLiteral(String label, URI datatype) {
        return this.createLiteral(label, datatype, null);
    }

    @Override
    public BigdataLiteralImpl createLiteral(String label, URI datatype, String language) {
        if (datatype != null && !(datatype instanceof BigdataURIImpl)) {
            datatype = this.createURI(datatype.stringValue());
        }
        return new BigdataLiteralImpl(this, label, language, (BigdataURIImpl)datatype);
    }

    @Override
    public BigdataURIImpl createURI(String uriString) {
        String str = uriString;
        BigdataURIImpl tmp = this.xsdMap.get(str);
        if (tmp != null) {
            return tmp;
        }
        return new BigdataURIImpl((BigdataValueFactory)this, uriString);
    }

    @Override
    public BigdataURIImpl createURI(String namespace, String localName) {
        return new BigdataURIImpl((BigdataValueFactory)this, namespace + localName);
    }

    @Override
    public BigdataStatementImpl createStatement(Resource s, URI p, Value o) {
        return this.createStatement(s, p, o, null, null);
    }

    @Override
    public BigdataStatementImpl createStatement(Resource s, URI p, Value o, Resource c) {
        return this.createStatement(s, p, o, c, null);
    }

    @Override
    public BigdataStatementImpl createStatement(Resource s, URI p, Value o, Resource c, StatementEnum type) {
        return this.createStatement(s, p, o, c, type, false);
    }

    @Override
    public BigdataStatementImpl createStatement(Resource s, URI p, Value o, Resource c, StatementEnum type, boolean userFlag) {
        return new BigdataStatementImpl(this.asValue(s), this.asValue(p), this.asValue(o), this.asValue(c), type, userFlag);
    }

    @Override
    public final BigdataValue asValue(Value v) {
        BigdataValueImpl v1;
        IV iv;
        if (v == null) {
            return null;
        }
        if (v instanceof BigdataValueImpl && ((BigdataValueImpl)v).getValueFactory() == this && ((iv = (v1 = (BigdataValueImpl)v).getIV()) == null || !iv.isNullIV())) {
            return (BigdataValue)v;
        }
        if (v instanceof BooleanLiteralImpl) {
            BooleanLiteralImpl bl = (BooleanLiteralImpl)v;
            return this.createLiteral(bl.booleanValue());
        }
        if (v instanceof URI) {
            return this.createURI(((URI)v).stringValue());
        }
        if (v instanceof BNode) {
            return this.createBNode(((BNode)v).stringValue());
        }
        if (v instanceof Literal) {
            Literal tmp = (Literal)v;
            String label = tmp.getLabel();
            String language = tmp.getLanguage();
            URI datatype = tmp.getDatatype();
            return new BigdataLiteralImpl(this, label, language, this.asValue(datatype));
        }
        throw new AssertionError();
    }

    @Override
    public BigdataValueSerializer<BigdataValue> getValueSerializer() {
        return this.valueSer;
    }

    @Override
    public BigdataResource asValue(Resource v) {
        return (BigdataResource)this.asValue((Value)v);
    }

    @Override
    public BigdataURI asValue(URI v) {
        return (BigdataURI)this.asValue((Value)v);
    }

    @Override
    public BigdataLiteral asValue(Literal v) {
        return (BigdataLiteral)this.asValue((Value)v);
    }

    @Override
    public BigdataBNode asValue(BNode v) {
        return (BigdataBNode)this.asValue((Value)v);
    }
}

