/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.openrdf.model.Literal;

public class XSDIntegerIV<V extends BigdataLiteral>
extends NumericIV<V, BigInteger>
implements Literal {
    private static final long serialVersionUID = 7530841693216602374L;
    private final BigInteger value;
    private transient int byteLength;

    @Override
    public IV<V, BigInteger> clone(boolean clearCache) {
        XSDIntegerIV tmp = new XSDIntegerIV(this.value);
        tmp.byteLength = this.byteLength;
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public XSDIntegerIV(BigInteger value) {
        super(DTE.XSDInteger);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    @Override
    public final BigInteger getInlineValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return !this.value.equals(BigInteger.ZERO);
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public final long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger integerValue() {
        return this.value;
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.value);
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = f.createLiteral(this.value.toString(), DTE.XSDInteger.getDatatypeURI());
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XSDIntegerIV) {
            return this.value.equals(((XSDIntegerIV)o).value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int byteLength() {
        if (this.byteLength == 0) {
            this.byteLength = 1 + KeyBuilder.byteLength(this.value);
        }
        return this.byteLength;
    }

    @Override
    public int _compareTo(IV o) {
        return this.value.compareTo(((XSDIntegerIV)o).value);
    }
}

