/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.extensions;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.PackedLongIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.Collections;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public class CompressedTimestampExtension<V extends BigdataValue>
implements IExtension<V> {
    private final BigdataURI datatype;
    public static final URI COMPRESSED_TIMESTAMP = new URIImpl("http://www.bigdata.com/rdf/datatype#compressedTimestamp");

    public CompressedTimestampExtension(IDatatypeURIResolver resolver) {
        this.datatype = resolver.resolve(COMPRESSED_TIMESTAMP);
    }

    @Override
    public Set<BigdataURI> getDatatypes() {
        return Collections.singleton(this.datatype);
    }

    @Override
    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException();
        }
        Literal lit = (Literal)value;
        PackedLongIV<BigdataLiteral> delegate = new PackedLongIV<BigdataLiteral>(Long.parseLong(lit.getLabel()));
        return new LiteralExtensionIV(delegate, this.datatype.getIV());
    }

    @Override
    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        AbstractLiteralIV<BigdataLiteral, ?> delegate = iv.getDelegate();
        if (delegate == null || !(delegate instanceof PackedLongIV)) {
            throw new IllegalArgumentException();
        }
        PackedLongIV pIv = (PackedLongIV)delegate;
        return (V)vf.createLiteral(String.valueOf(pIv.getInlineValue()), COMPRESSED_TIMESTAMP);
    }
}

