/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.IBindingSet;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.rdf.internal.encoder.IVSolutionSetDecoder;
import com.bigdata.rdf.internal.encoder.SolutionSetStreamEncoder;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class SolutionSetStreamDecoder
implements ICloseableIterator<IBindingSet[]> {
    private static final Logger log = Logger.getLogger(SolutionSetStreamDecoder.class);
    private final String name;
    private final long solutionSetCount;
    private final DataInputStream in;
    private final IVSolutionSetDecoder decoder;
    private boolean open = false;
    private IBindingSet[] bsets = null;
    private long nsolutions = 0L;

    public SolutionSetStreamDecoder(String name, DataInputStream in, long solutionSetCount) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        if (solutionSetCount < 0L) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.solutionSetCount = solutionSetCount;
        this.in = in;
        this.open = true;
        this.decoder = new IVSolutionSetDecoder();
    }

    public void close() {
        if (this.open) {
            this.open = false;
            try {
                this.in.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public boolean hasNext() {
        if (this.open && this.bsets == null) {
            try {
                this.bsets = this.decodeNextChunk();
                if (this.bsets == null) {
                    this.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.open && this.bsets != null;
    }

    private IBindingSet[] decodeNextChunk() throws IOException {
        if (this.nsolutions == this.solutionSetCount) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read solutionSet: name=" + this.name + ", solutionSetSize=" + this.nsolutions));
            }
            return null;
        }
        this.in.readInt();
        int chunkSize = this.in.readInt();
        int byteLength = this.in.readInt();
        byte[] a = new byte[byteLength];
        this.in.readFully(a);
        DataInputBuffer buf = new DataInputBuffer(a);
        IBindingSet[] t = new IBindingSet[chunkSize];
        for (int i = 0; i < chunkSize; ++i) {
            t[i] = this.decoder.decodeSolution(buf, true);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Read: name=" + this.name + ", solution=" + t[i]));
        }
        this.nsolutions += (long)chunkSize;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read chunk: name=" + this.name + ", chunkSize=" + chunkSize + ", bytesRead=" + (SolutionSetStreamEncoder.CHUNK_HEADER_SIZE + byteLength) + ", solutionSetSize=" + this.nsolutions));
        }
        return t;
    }

    public IBindingSet[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IBindingSet[] t = this.bsets;
        this.bsets = null;
        return t;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

