/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IMathOpHandler;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.constraints.NumericBOp;
import com.bigdata.rdf.internal.impl.extensions.CompressedTimestampExtension;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;

public class MathUtility
implements IMathOpHandler {
    public static boolean checkNumericDatatype(Literal ... args) {
        for (Literal lit : args) {
            URI dt = lit.getDatatype();
            if (dt == null) {
                return false;
            }
            boolean isNumeric = false;
            isNumeric |= XMLDatatypeUtil.isNumericDatatype((URI)dt);
            if (isNumeric |= dt.equals((Object)CompressedTimestampExtension.COMPRESSED_TIMESTAMP)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canInvokeMathOp(Literal ... args) {
        return MathUtility.checkNumericDatatype(args);
    }

    @Override
    public NumericIV doMathOp(Literal l1, IV iv1, Literal l2, IV iv2, MathBOp.MathOp op, BigdataValueFactory vf) {
        return MathUtility.literalMath(l1, l2, op);
    }

    public static NumericIV literalMath(Literal l1, Literal l2, MathBOp.MathOp op) {
        if (!MathUtility.checkNumericDatatype(l1, l2)) {
            throw new IllegalArgumentException("Not numbers: " + l1 + ", " + l2);
        }
        URI dt1 = l1.getDatatype();
        URI dt2 = l2.getDatatype();
        URI commonDatatype = dt1.equals((Object)XMLSchema.DOUBLE) || dt2.equals((Object)XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (dt1.equals((Object)XMLSchema.FLOAT) || dt2.equals((Object)XMLSchema.FLOAT) ? XMLSchema.FLOAT : (dt1.equals((Object)XMLSchema.DECIMAL) || dt2.equals((Object)XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : (op == MathBOp.MathOp.DIVIDE ? XMLSchema.DECIMAL : XMLSchema.INTEGER)));
        try {
            if (commonDatatype.equals((Object)XMLSchema.DOUBLE)) {
                double left = l1.doubleValue();
                double right = l2.doubleValue();
                return MathUtility.numericalMath(left, right, op);
            }
            if (commonDatatype.equals((Object)XMLSchema.FLOAT)) {
                float left = l1.floatValue();
                float right = l2.floatValue();
                return MathUtility.numericalMath(left, right, op);
            }
            if (commonDatatype.equals((Object)XMLSchema.DECIMAL)) {
                BigDecimal left = l1.decimalValue();
                BigDecimal right = l2.decimalValue();
                return MathUtility.numericalMath(left, right, op);
            }
            BigInteger left = l1.integerValue();
            BigInteger right = l2.integerValue();
            return MathUtility.numericalMath(left, right, op);
        }
        catch (NumberFormatException e) {
            throw new SparqlTypeErrorException();
        }
        catch (ArithmeticException e) {
            throw new SparqlTypeErrorException();
        }
    }

    public static final NumericIV numericalFunc(Literal lit, NumericBOp.NumericOp op) {
        if (!MathUtility.checkNumericDatatype(lit)) {
            throw new IllegalArgumentException("not numeric: " + lit);
        }
        URI dte1 = lit.getDatatype();
        if (dte1.equals((Object)XMLSchema.DECIMAL)) {
            return MathUtility.numericalFunc(lit.decimalValue(), op);
        }
        if (dte1.equals((Object)XMLSchema.INTEGER)) {
            return MathUtility.numericalFunc(lit.integerValue(), op);
        }
        if (dte1.equals((Object)XMLSchema.FLOAT)) {
            return MathUtility.numericalFunc(lit.floatValue(), op);
        }
        if (dte1.equals((Object)XMLSchema.INT)) {
            return MathUtility.numericalFunc(lit.intValue(), op);
        }
        if (dte1.equals((Object)XMLSchema.DOUBLE)) {
            return MathUtility.numericalFunc(lit.doubleValue(), op);
        }
        return MathUtility.numericalFunc(lit.longValue(), op);
    }

    @Deprecated
    private static final NumericIV numericalFunc(BigDecimal left, NumericBOp.NumericOp op) {
        switch (op) {
            case ABS: {
                return new XSDDecimalIV(left.abs());
            }
            case CEIL: {
                return new XSDDecimalIV(new BigDecimal(Math.round(Math.ceil(left.doubleValue()))));
            }
            case FLOOR: {
                return new XSDDecimalIV(new BigDecimal(Math.round(Math.floor(left.doubleValue()))));
            }
            case ROUND: {
                return new XSDDecimalIV(new BigDecimal(Math.round(left.doubleValue())));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    private static final NumericIV numericalFunc(BigInteger left, NumericBOp.NumericOp op) {
        switch (op) {
            case ABS: {
                return new XSDIntegerIV(left.abs());
            }
            case CEIL: {
                return new XSDNumericIV(Math.ceil(left.doubleValue()));
            }
            case FLOOR: {
                return new XSDNumericIV(Math.floor(left.doubleValue()));
            }
            case ROUND: {
                return new XSDNumericIV(Math.round(left.doubleValue()));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    private static final NumericIV numericalFunc(float left, NumericBOp.NumericOp op) {
        switch (op) {
            case ABS: {
                return new XSDNumericIV(Math.abs(left));
            }
            case CEIL: {
                return new XSDNumericIV(Math.ceil(left));
            }
            case FLOOR: {
                return new XSDNumericIV(Math.floor(left));
            }
            case ROUND: {
                return new XSDNumericIV(Math.round(left));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    private static final NumericIV numericalFunc(int left, NumericBOp.NumericOp op) {
        switch (op) {
            case ABS: {
                return new XSDNumericIV(Math.abs(left));
            }
            case CEIL: {
                return new XSDNumericIV(Math.ceil(left));
            }
            case FLOOR: {
                return new XSDNumericIV(Math.floor(left));
            }
            case ROUND: {
                return new XSDNumericIV(Math.round(left));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    private static final NumericIV numericalFunc(long left, NumericBOp.NumericOp op) {
        switch (op) {
            case ABS: {
                return new XSDNumericIV(Math.abs(left));
            }
            case CEIL: {
                return new XSDNumericIV(Math.ceil(left));
            }
            case FLOOR: {
                return new XSDNumericIV(Math.floor(left));
            }
            case ROUND: {
                return new XSDNumericIV(Math.round(left));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    private static final NumericIV numericalFunc(double left, NumericBOp.NumericOp op) {
        switch (op) {
            case ABS: {
                return new XSDNumericIV(Math.abs(left));
            }
            case CEIL: {
                return new XSDNumericIV(Math.ceil(left));
            }
            case FLOOR: {
                return new XSDNumericIV(Math.floor(left));
            }
            case ROUND: {
                return new XSDNumericIV(Math.round(left));
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final NumericIV numericalMath(BigDecimal left, BigDecimal right, MathBOp.MathOp op) {
        switch (op) {
            case PLUS: {
                return new XSDDecimalIV(left.add(right));
            }
            case MINUS: {
                return new XSDDecimalIV(left.subtract(right));
            }
            case MULTIPLY: {
                return new XSDDecimalIV(left.multiply(right));
            }
            case DIVIDE: {
                try {
                    return new XSDDecimalIV(left.divide(right));
                }
                catch (ArithmeticException ae) {
                    return new XSDDecimalIV(left.divide(right, 20, RoundingMode.HALF_UP));
                }
            }
            case MIN: {
                return new XSDDecimalIV(left.compareTo(right) < 0 ? left : right);
            }
            case MAX: {
                return new XSDDecimalIV(left.compareTo(right) > 0 ? left : right);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final NumericIV numericalMath(BigInteger left, BigInteger right, MathBOp.MathOp op) {
        switch (op) {
            case PLUS: {
                return new XSDIntegerIV(left.add(right));
            }
            case MINUS: {
                return new XSDIntegerIV(left.subtract(right));
            }
            case MULTIPLY: {
                return new XSDIntegerIV(left.multiply(right));
            }
            case DIVIDE: {
                return new XSDIntegerIV(left.divide(right));
            }
            case MIN: {
                return new XSDIntegerIV(left.compareTo(right) < 0 ? left : right);
            }
            case MAX: {
                return new XSDIntegerIV(left.compareTo(right) > 0 ? left : right);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final NumericIV numericalMath(float left, float right, MathBOp.MathOp op) {
        switch (op) {
            case PLUS: {
                return new XSDNumericIV(left + right);
            }
            case MINUS: {
                return new XSDNumericIV(left - right);
            }
            case MULTIPLY: {
                return new XSDNumericIV(left * right);
            }
            case DIVIDE: {
                return new XSDNumericIV(left / right);
            }
            case MIN: {
                return new XSDNumericIV(Math.min(left, right));
            }
            case MAX: {
                return new XSDNumericIV(Math.max(left, right));
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final NumericIV numericalMath(double left, double right, MathBOp.MathOp op) {
        switch (op) {
            case PLUS: {
                return new XSDNumericIV(left + right);
            }
            case MINUS: {
                return new XSDNumericIV(left - right);
            }
            case MULTIPLY: {
                return new XSDNumericIV(left * right);
            }
            case DIVIDE: {
                return new XSDNumericIV(left / right);
            }
            case MIN: {
                return new XSDNumericIV(Math.min(left, right));
            }
            case MAX: {
                return new XSDNumericIV(Math.max(left, right));
            }
        }
        throw new UnsupportedOperationException();
    }
}

