/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.Banner;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.impl.bd.BigdataGASEngine;
import com.bigdata.rdf.graph.impl.bd.BigdataGraphFixture;
import com.bigdata.rdf.graph.impl.util.GASRunnerBase;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openrdf.sail.SailConnection;

public class BigdataGASRunner<VS, ES, ST>
extends GASRunnerBase<VS, ES, ST> {
    private static final Logger log = Logger.getLogger(BigdataGASRunner.class);

    protected GASRunnerBase.OptionData newOptionData() {
        return new BigdataOptionData();
    }

    protected BigdataGASEngine newGASEngine() {
        BigdataOptionData opt = this.getOptionData();
        return new BigdataGASEngine(opt.jnl, opt.nthreads);
    }

    protected IGraphAccessor newGraphAccessor() {
        BigdataOptionData opt = this.getOptionData();
        BigdataGASEngine.BigdataGraphAccessor graphAccessor = new BigdataGASEngine.BigdataGraphAccessor(opt.jnl, opt.namespace, opt.jnl.getLastCommitTime());
        return graphAccessor;
    }

    protected BigdataOptionData getOptionData() {
        return (BigdataOptionData)super.getOptionData();
    }

    public BigdataGASRunner(String[] args) throws ClassNotFoundException {
        super(args);
        Banner.banner();
    }

    protected IGASProgram<VS, ES, ST> newGASProgram() {
        Class cls = this.getOptionData().analyticClass;
        try {
            Constructor ctor = cls.getConstructor(new Class[0]);
            IGASProgram gasProgram = (IGASProgram)ctor.newInstance(new Object[0]);
            return gasProgram;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFiles() throws IOException {
        BigdataOptionData opt = this.getOptionData();
        Journal jnl = opt.jnl;
        String namespace = opt.namespace;
        String[] loadSet = opt.loadSet.toArray(new String[0]);
        AbstractTripleStore kb = (AbstractTripleStore)jnl.getResourceLocator().locate(namespace, 0L);
        if (opt.newKB && loadSet.length > 0) {
            BigdataSail sail = new BigdataSail(kb);
            try {
                try {
                    sail.initialize();
                    this.loadFiles(sail, loadSet);
                }
                finally {
                    if (sail.isOpen()) {
                        sail.shutDown();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        opt.nedges = kb.getStatementCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles(BigdataSail sail, String[] loadSet) throws Exception {
        boolean ok = false;
        BigdataSail.BigdataSailConnection cxn = sail.getUnisolatedConnection();
        try {
            BigdataGraphFixture.BigdataSailGraphLoader loader = new BigdataGraphFixture.BigdataSailGraphLoader((SailConnection)cxn);
            for (String f : loadSet) {
                loader.loadGraph(null, f);
            }
            cxn.commit();
            ok = true;
        }
        finally {
            if (!ok) {
                cxn.rollback();
            }
            cxn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new BigdataGASRunner(args).call();
    }

    protected class BigdataOptionData
    extends GASRunnerBase.OptionData {
        private BufferMode bufferModeOverride;
        private String namespaceOverride;
        private Properties properties;
        private String namespace;
        private Journal jnl;
        private boolean isTemporary;
        private boolean newKB;
        private long nedges;

        protected BigdataOptionData() {
            super((GASRunnerBase)BigdataGASRunner.this);
            this.bufferModeOverride = null;
            this.namespaceOverride = "kb";
            this.newKB = false;
            this.nedges = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getProperties(String resource) throws IOException {
            if (log.isInfoEnabled()) {
                log.info((Object)("Reading properties: " + resource));
            }
            InputStream is = null;
            try {
                String[] overrides;
                is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
                if (is == null) {
                    File file = new File(resource);
                    if (file.exists()) {
                        is = new FileInputStream(file);
                    } else {
                        throw new IOException("Could not locate resource: " + resource);
                    }
                }
                Properties properties = new Properties();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                try {
                    properties.load(reader);
                }
                finally {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable t) {
                        log.error((Object)t);
                    }
                }
                for (String s : overrides = new String[]{Options.FILE}) {
                    if (System.getProperty(s) == null) continue;
                    String v = System.getProperty(s);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("OVERRIDE:: Using: " + s + "=" + v));
                    }
                    properties.setProperty(s, v);
                }
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable t) {
                        log.error((Object)t);
                    }
                }
            }
        }

        public void init() throws Exception {
            AbstractTripleStore kb;
            boolean isTransient;
            super.init();
            this.properties = this.getProperties(this.propertyFile);
            BufferMode bufferMode = this.bufferModeOverride == null ? BufferMode.valueOf(this.properties.getProperty(Journal.Options.BUFFER_MODE, Journal.Options.DEFAULT_BUFFER_MODE)) : this.bufferModeOverride;
            this.properties.setProperty(Journal.Options.BUFFER_MODE, bufferMode.name());
            boolean bl = isTransient = !bufferMode.isStable();
            if (isTransient) {
                this.isTemporary = true;
            } else {
                String fileStr = this.properties.getProperty(Journal.Options.FILE);
                if (fileStr == null) {
                    this.isTemporary = true;
                    File tmpFile = File.createTempFile(BigdataGASRunner.class.getSimpleName(), ".jnl");
                    this.properties.setProperty(Journal.Options.FILE, tmpFile.getAbsolutePath());
                } else {
                    this.isTemporary = false;
                }
            }
            this.namespace = this.namespaceOverride == null ? this.properties.getProperty(BigdataSail.Options.NAMESPACE, "kb") : this.namespaceOverride;
            this.properties.setProperty(BigdataSail.Options.NAMESPACE, this.namespace);
            this.jnl = new Journal(this.properties);
            if (this.isTemporary) {
                kb = BigdataSail.createLTS(this.jnl, this.properties);
                this.newKB = true;
            } else {
                AbstractTripleStore tmp = (AbstractTripleStore)this.jnl.getResourceLocator().locate(this.namespace, 0L);
                if (tmp == null) {
                    kb = BigdataSail.createLTS(this.jnl, this.properties);
                    this.newKB = true;
                } else {
                    kb = tmp;
                    this.newKB = kb.getStatementCount() == 0L;
                }
            }
        }

        public void shutdown() {
            if (this.jnl != null) {
                if (this.isTemporary) {
                    log.warn((Object)"Destroying temporary journal.");
                    this.jnl.destroy();
                } else {
                    this.jnl.close();
                }
            }
            super.shutdown();
        }

        public boolean handleArg(AtomicInteger i, String[] args) {
            if (super.handleArg(i, args)) {
                return true;
            }
            String arg = args[i.get()];
            if (arg.equals("-bufferMode")) {
                String s = args[i.incrementAndGet()];
                this.bufferModeOverride = BufferMode.valueOf(s);
            } else if (arg.equals("-namespace")) {
                String s;
                this.namespaceOverride = s = args[i.incrementAndGet()];
            } else {
                return false;
            }
            return true;
        }

        public void report(StringBuilder sb) {
            sb.append(", edges(kb)=" + this.nedges);
            sb.append(", namespace=" + this.namespace);
            sb.append(", bufferMode=" + (Object)((Object)this.jnl.getBufferStrategy().getBufferMode()));
        }
    }
}

