/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

public class TimestampUtility {
    public static String toString(long timestamp) {
        if (timestamp == 0L) {
            return "unisolated";
        }
        if (timestamp == -1L) {
            return "read-committed";
        }
        if (TimestampUtility.isReadWriteTx(timestamp)) {
            return "readWriteTX(" + timestamp + ")";
        }
        return "readOnly(" + timestamp + ")";
    }

    public static boolean isCommitTime(long timestamp) {
        return timestamp > 0L;
    }

    public static boolean isReadOnly(long timestamp) {
        return timestamp > 0L || timestamp == -1L;
    }

    public static boolean isReadWriteTx(long timestamp) {
        return timestamp < -1L;
    }

    public static boolean isReadCommittedOrUnisolated(long timestamp) {
        return timestamp == -1L || timestamp == 0L;
    }

    public static boolean isReadCommitted(long timestamp) {
        return timestamp == -1L;
    }

    public static boolean isUnisolated(long timestamp) {
        return timestamp == 0L;
    }

    public static long asHistoricalRead(long commitTime) {
        if (commitTime < 0L) {
            throw new IllegalArgumentException("commitTime: " + commitTime);
        }
        return commitTime;
    }
}

