/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.IHABufferStrategy;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.ISnapshotFactory;
import com.bigdata.journal.ISnapshotResult;
import com.bigdata.journal.Journal;
import com.bigdata.journal.SnapshotResult;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class SnapshotTask
implements Callable<ISnapshotResult> {
    private final Journal journal;
    private final ISnapshotFactory snapshotFactory;
    protected static final Logger log = Logger.getLogger(SnapshotTask.class);
    public static final String SNAPSHOT_TMP_PREFIX = "snapshot";
    public static final String SNAPSHOT_TMP_SUFFIX = ".tmp";

    public SnapshotTask(Journal journal, ISnapshotFactory snapshotFactory) {
        if (journal == null) {
            throw new IllegalArgumentException();
        }
        if (snapshotFactory == null) {
            throw new IllegalArgumentException();
        }
        this.journal = journal;
        this.snapshotFactory = snapshotFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISnapshotResult call() throws Exception {
        long txId = this.journal.newTx(-1L);
        try {
            AtomicReference<IRootBlockView> rbv = new AtomicReference<IRootBlockView>();
            AbstractJournal.ISnapshotData coreData = this.journal.snapshotAllocationData(rbv);
            if (rbv.get().getCommitCounter() == 0L) {
                throw new IllegalStateException("Journal is empty");
            }
            File file = this.snapshotFactory.getSnapshotFile(rbv.get());
            if (file.exists() && file.length() != 0L) {
                throw new IOException("File exists: " + file);
            }
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new IOException("Could not create directory: " + parentDir);
            }
            File tmp = File.createTempFile(SNAPSHOT_TMP_PREFIX, SNAPSHOT_TMP_SUFFIX, parentDir);
            OutputStream osx = null;
            FilterOutputStream os = null;
            boolean success = false;
            try {
                osx = new FileOutputStream(tmp);
                if (this.snapshotFactory.getCompress()) {
                    osx = new GZIPOutputStream(osx);
                }
                os = new DataOutputStream(osx);
                ((IHABufferStrategy)this.journal.getBufferStrategy()).writeOnStream(os, coreData, null, -1L);
                ((DataOutputStream)os).flush();
                success = true;
            }
            catch (Throwable t) {
                Journal.log.error((Object)t, t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    finally {
                        os = null;
                        osx = null;
                    }
                }
                if (osx != null) {
                    try {
                        osx.close();
                    }
                    finally {
                        osx = null;
                    }
                }
                if (success) {
                    if (!tmp.renameTo(file)) {
                        Journal.log.error((Object)("Could not rename " + tmp + " as " + file));
                    } else if (Journal.log.isInfoEnabled()) {
                        Journal.log.info((Object)("Captured snapshot: " + file + ", commitCounter=" + rbv.get().getCommitCounter() + ", length=" + file.length()));
                    }
                } else if (!tmp.delete()) {
                    Journal.log.warn((Object)("Could not delete temporary file: " + tmp));
                }
            }
            SnapshotResult snapshotResult = new SnapshotResult(file, this.snapshotFactory.getCompress(), rbv.get());
            return snapshotResult;
        }
        finally {
            this.journal.abort(txId);
        }
    }

    private static void copyStream(InputStream content, OutputStream outstr) throws IOException {
        int rdlen;
        byte[] buf = new byte[1024];
        while ((rdlen = content.read(buf)) > 0) {
            outstr.write(buf, 0, rdlen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(File src, File dst) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src.getAbsolutePath());
        }
        if (dst.exists() && dst.length() != 0L) {
            throw new IOException("Output file exists and is not empty: " + dst.getAbsolutePath());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("src=" + src + ", dst=" + dst));
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = new GZIPInputStream(new FileInputStream(src));
            os = new FileOutputStream(dst);
            SnapshotTask.copyStream(is, os);
            os.flush();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

