/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.compression;

import com.bigdata.io.ByteBufferInputStream;
import com.bigdata.io.ByteBufferOutputStream;
import com.bigdata.io.compression.IRecordCompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipCompressor
implements IRecordCompressor {
    @Override
    public void compress(ByteBuffer bin, ByteBuffer out) {
        this.compress(bin, (OutputStream)new ByteBufferOutputStream(out));
    }

    @Override
    public ByteBuffer compress(ByteBuffer bin) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.compress(bin, (OutputStream)os);
        return ByteBuffer.wrap(os.toByteArray());
    }

    @Override
    public void compress(ByteBuffer bin, OutputStream os) {
        try {
            GZIPOutputStream gzout = new GZIPOutputStream(os);
            DataOutputStream dout = new DataOutputStream(gzout);
            dout.writeInt(bin.limit());
            if (bin.hasArray()) {
                dout.write(bin.array());
            } else {
                byte[] tbuf = new byte[bin.limit()];
                bin.get(tbuf);
                dout.write(tbuf);
            }
            dout.flush();
            gzout.flush();
            dout.close();
            gzout.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void compress(byte[] bytes, OutputStream os) {
        this.compress(bytes, 0, bytes.length, os);
    }

    @Override
    public void compress(byte[] bytes, int off, int len, OutputStream os) {
        try {
            GZIPOutputStream gzout = new GZIPOutputStream(os);
            DataOutputStream dout = new DataOutputStream(gzout);
            dout.writeInt(len);
            dout.write(bytes, off, len);
            dout.flush();
            gzout.flush();
            dout.close();
            gzout.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteBuffer decompress(ByteBuffer bin) {
        InputStream instr = bin.hasArray() ? new ByteArrayInputStream(bin.array()) : new ByteBufferInputStream(bin);
        return this.decompress(instr);
    }

    @Override
    public ByteBuffer decompress(byte[] bin) {
        return this.decompress(new ByteArrayInputStream(bin));
    }

    public ByteBuffer decompress(InputStream instr) {
        try {
            int rdlen;
            GZIPInputStream gzin = new GZIPInputStream(instr);
            DataInputStream din = new DataInputStream(gzin);
            int length = din.readInt();
            byte[] xbuf = new byte[length];
            for (int cursor = 0; cursor < length; cursor += rdlen) {
                rdlen = din.read(xbuf, cursor, length - cursor);
            }
            return ByteBuffer.wrap(xbuf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

