/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree.raba;

import com.bigdata.btree.raba.AbstractRaba;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.util.BytesUtil;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class MutableKeyBuffer
implements IRaba {
    public int nkeys;
    public final byte[][] keys;

    private static void checkCapacity(int capacity) {
        if (capacity <= 1 || (capacity & -capacity) != capacity) {
            throw new IllegalArgumentException("capacity must be 2^n where n is positive, not " + capacity);
        }
    }

    public MutableKeyBuffer(int capacity) {
        MutableKeyBuffer.checkCapacity(capacity);
        this.nkeys = 0;
        this.keys = new byte[capacity][];
    }

    public MutableKeyBuffer(int nkeys, byte[][] keys) {
        if (keys == null) {
            throw new IllegalArgumentException();
        }
        if (nkeys < 0 || nkeys > keys.length) {
            throw new IllegalArgumentException();
        }
        MutableKeyBuffer.checkCapacity(keys.length);
        this.nkeys = nkeys;
        this.keys = keys;
    }

    public MutableKeyBuffer(MutableKeyBuffer src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        MutableKeyBuffer.checkCapacity(src.capacity());
        this.nkeys = src.nkeys;
        this.keys = new byte[src.keys.length][];
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = src.keys[i];
        }
    }

    public MutableKeyBuffer(int capacity, IRaba src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        MutableKeyBuffer.checkCapacity(capacity);
        if (capacity < src.capacity()) {
            throw new IllegalArgumentException();
        }
        this.nkeys = src.size();
        this.keys = new byte[capacity][];
        int i = 0;
        for (byte[] a : src) {
            this.keys[i++] = a;
        }
    }

    public String toString() {
        return AbstractRaba.toString(this);
    }

    @Override
    public final byte[] get(int index) {
        return this.keys[index];
    }

    @Override
    public final int length(int index) {
        byte[] tmp = this.keys[index];
        if (tmp == null) {
            throw new NullPointerException();
        }
        return tmp.length;
    }

    @Override
    public final int copy(int index, OutputStream out) {
        byte[] tmp = this.keys[index];
        try {
            out.write(tmp, 0, tmp.length);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return tmp.length;
    }

    @Override
    public final boolean isNull(int index) {
        return this.keys[index] == null;
    }

    @Override
    public final boolean isEmpty() {
        return this.nkeys == 0;
    }

    @Override
    public final int size() {
        return this.nkeys;
    }

    @Override
    public final int capacity() {
        return this.keys.length;
    }

    @Override
    public final boolean isFull() {
        return this.nkeys == this.keys.length;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isKeys() {
        return true;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < MutableKeyBuffer.this.size();
            }

            @Override
            public byte[] next() {
                return MutableKeyBuffer.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final void set(int index, byte[] key) {
        assert (key != null);
        assert (this.keys[index] == null);
        assert (this.nkeys < this.keys.length);
        this.keys[index] = key;
        ++this.nkeys;
    }

    public final void insert(int index, byte[] key) {
        assert (key != null);
        if (this.keys[index] != null) {
            assert (this.keys[this.nkeys] == null);
            System.arraycopy(this.keys, index, this.keys, index + 1, this.nkeys - index);
        }
        this.keys[index] = key;
        ++this.nkeys;
    }

    public final int remove(int index) {
        assert (this.keys[index] != null);
        assert (this.nkeys > 0);
        System.arraycopy(this.keys, index + 1, this.keys, index, this.nkeys - index - 1);
        this.keys[this.nkeys - 1] = null;
        return --this.nkeys;
    }

    @Override
    public final int add(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int add(byte[] key, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int add(DataInput in, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int search(byte[] key) {
        return this.search(key, this.keys, 0, this.capacity());
    }

    private int search(byte[] key, byte[][] keys, int start, int length) {
        int tst;
        if (length == 1) {
            byte[] tstkey = keys[start];
            if (tstkey == null) {
                return -(start + 1);
            }
            int res = BytesUtil.compareBytes((byte[])key, (byte[])tstkey);
            if (res == 0) {
                return start;
            }
            if (res < 0) {
                return -(start + 1);
            }
            return -(start + 2);
        }
        int partLen = length >> 1;
        int pivot = start + partLen;
        byte[] pivotKey = keys[pivot];
        int n = tst = pivotKey == null ? -1 : BytesUtil.compareBytes((byte[])key, (byte[])pivotKey);
        if (tst == 0 && BytesUtil.compareBytes((byte[])key, (byte[])keys[pivot - 1]) != 0) {
            return pivot;
        }
        if (tst <= 0) {
            return this.search(key, keys, start, partLen);
        }
        return this.search(key, keys, pivot, partLen);
    }
}

