/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.data.AbstractReadOnlyNodeData;
import com.bigdata.btree.data.DefaultLeafCoder;
import com.bigdata.btree.data.IAbstractNodeData;
import com.bigdata.btree.data.IAbstractNodeDataCoder;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.htree.AbstractHTree;
import com.bigdata.htree.AbstractPage;
import com.bigdata.htree.INodeFactory;
import com.bigdata.htree.data.DefaultDirectoryPageCoder;
import com.bigdata.htree.data.IDirectoryData;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.FixedByteArrayBuffer;
import com.bigdata.io.compression.IRecordCompressor;
import com.bigdata.io.compression.IRecordCompressorFactory;
import com.bigdata.io.compression.NOPRecordCompressor;
import com.bigdata.rawstore.IAddressManager;
import java.nio.ByteBuffer;

public class NodeSerializer {
    protected final INodeFactory nodeFactory;
    private final boolean readOnly;
    final IAbstractNodeDataCoder<IDirectoryData> nodeCoder;
    final IAbstractNodeDataCoder<ILeafData> leafCoder;
    private final IRecordCompressorFactory<?> recordCompressorFactory;
    private DataOutputBuffer _writeBuffer;
    private IRecordCompressor _writeCompressor;
    private final int initialBufferCapacity;
    public static final transient int DEFAULT_BUFFER_CAPACITY_PER_ENTRY = 256;

    private IRecordCompressor getRecordCompressor() {
        if (this.recordCompressorFactory == null) {
            return NOPRecordCompressor.INSTANCE;
        }
        if (!this.readOnly) {
            assert (this._writeCompressor != null);
            return this._writeCompressor;
        }
        return this.recordCompressorFactory.getInstance();
    }

    private NodeSerializer() {
        throw new UnsupportedOperationException();
    }

    public NodeSerializer(IAddressManager addressManager, INodeFactory nodeFactory, int addressBits, int initialBufferCapacity, IndexMetadata indexMetadata, boolean readOnly, IRecordCompressorFactory<?> recordCompressorFactory) {
        assert (nodeFactory != null);
        assert (initialBufferCapacity >= 0);
        assert (indexMetadata != null);
        this.nodeFactory = nodeFactory;
        this.readOnly = readOnly;
        this.nodeCoder = new DefaultDirectoryPageCoder();
        if (!indexMetadata.getTupleSerializer().getLeafKeysCoder().isDuplicateKeys()) {
            throw new IllegalArgumentException("The leaf keys coder for HTree should allow duplicate keys.");
        }
        this.leafCoder = new DefaultLeafCoder(indexMetadata.getTupleSerializer().getLeafKeysCoder(), indexMetadata.getTupleSerializer().getLeafValuesCoder());
        this.recordCompressorFactory = recordCompressorFactory;
        if (readOnly) {
            this.initialBufferCapacity = 0;
            this._writeBuffer = null;
        } else {
            if (initialBufferCapacity == 0) {
                int branchingFactor = 1 << addressBits;
                this.initialBufferCapacity = 256 * branchingFactor;
            } else {
                this.initialBufferCapacity = initialBufferCapacity;
            }
            this.allocWriteBuffer();
        }
    }

    public void close() {
        this._writeBuffer = null;
        this._writeCompressor = null;
    }

    private void allocWriteBuffer() {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        assert (this._writeBuffer == null);
        assert (this._writeCompressor == null);
        this._writeBuffer = new DataOutputBuffer(this.initialBufferCapacity);
        this._writeCompressor = this.recordCompressorFactory == null ? NOPRecordCompressor.INSTANCE : this.recordCompressorFactory.getInstance();
    }

    public IAbstractNodeData decode(ByteBuffer buf) {
        FixedByteArrayBuffer slice;
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        boolean isNode = AbstractReadOnlyNodeData.isNode(buf.get(0));
        if (!buf.hasArray()) {
            byte[] tmp = new byte[buf.remaining()];
            buf.get(tmp);
            slice = FixedByteArrayBuffer.wrap(tmp);
            if (BigdataStatics.debug) {
                System.err.print("[RO]");
            }
        } else {
            slice = new FixedByteArrayBuffer(buf.array(), buf.arrayOffset(), buf.capacity());
        }
        if (isNode) {
            return this.nodeCoder.decode(slice);
        }
        return this.leafCoder.decode(slice);
    }

    public AbstractPage wrap(AbstractHTree btree, long addr, IAbstractNodeData data) {
        if (data.isLeaf()) {
            return this.nodeFactory.allocLeaf(btree, addr, (ILeafData)data);
        }
        return this.nodeFactory.allocNode(btree, addr, (IDirectoryData)data);
    }

    public <T extends IAbstractNodeData> T encodeLive(T node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (node.isCoded()) {
            throw new IllegalStateException();
        }
        if (this._writeBuffer == null) {
            this.allocWriteBuffer();
        } else {
            this._writeBuffer.reset();
        }
        IAbstractNodeData codedNode = node.isLeaf() ? this.leafCoder.encodeLive((ILeafData)node, this._writeBuffer) : this.nodeCoder.encodeLive((IDirectoryData)node, this._writeBuffer);
        this._writeBuffer = new DataOutputBuffer(0, this._writeBuffer.trim());
        return (T)codedNode;
    }

    public AbstractFixedByteArrayBuffer encode(IAbstractNodeData node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (node.isCoded()) {
            throw new IllegalStateException();
        }
        if (this._writeBuffer == null) {
            this.allocWriteBuffer();
        } else {
            this._writeBuffer.reset();
        }
        if (node.isLeaf()) {
            return this.leafCoder.encode((ILeafData)node, this._writeBuffer);
        }
        return this.nodeCoder.encode((IDirectoryData)node, this._writeBuffer);
    }

    public void updateLeaf(ByteBuffer b, long priorAddr, long nextAddr) {
        if (AbstractReadOnlyNodeData.isNode(b.get(0))) {
            throw new UnsupportedOperationException("Not a leaf.");
        }
        b.putLong(1, priorAddr);
        b.putLong(9, nextAddr);
    }
}

