/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.mdi.LocalPartitionMetadata;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RangeCountProcedure
extends AbstractKeyRangeIndexProcedure<Long>
implements IParallelizableIndexProcedure<Long> {
    private static final long serialVersionUID = 5856712176446915328L;
    private boolean exact;
    private boolean deleted;

    public RangeCountProcedure() {
    }

    public RangeCountProcedure(boolean exact, boolean deleted, byte[] fromKey, byte[] toKey) {
        super(fromKey, toKey);
        if (!exact && deleted) {
            throw new IllegalArgumentException();
        }
        this.exact = exact;
        this.deleted = deleted;
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    public final boolean isExact() {
        return this.exact;
    }

    public final boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Long apply(IIndex ndx) {
        LocalPartitionMetadata pmd = ndx.getIndexMetadata().getPartitionMetadata();
        byte[] fromKey = RangeCountProcedure.constrainFromKey(this.fromKey, pmd);
        byte[] toKey = RangeCountProcedure.constrainToKey(this.toKey, pmd);
        long rangeCount = this.exact ? (this.deleted ? ndx.rangeCountExactWithDeleted(fromKey, toKey) : ndx.rangeCountExact(fromKey, toKey)) : ndx.rangeCount(fromKey, toKey);
        return rangeCount;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.exact = in.readBoolean();
        this.deleted = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.exact);
        out.writeBoolean(this.deleted);
    }
}

